package com.digiwin.mobile.mobileuibot.core.component.list.card;

import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.audc.model.DigiwinAtmcGroupRecord;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * CARD_LIST组件分组功能--组选项
 *
 * @author zhangjj
 * @date 2022/10/10 10:04
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CardListGroupOption extends CardListOption implements Serializable {
    private static final long serialVersionUID = 6706095701903736333L;
    /**
     * 分组标签类型
     *
     * @see CardListGroupOptionTypeEnum
     */
    private String type;
    /**
     * 默认生效，前端重置分组时使用
     */
    private Boolean defaultEffective;
    // 团队项目中按项目时间分组 使用
    private CardListGroupOptionConfigs optionConfigs;
    // 排序 asc/desc
    private String sort;

    public void convertOptionConfigs(LocaleService localeService, String locale, DigiwinAtmcGroupRecord.Config configs, CardListGroupOptionConfigs customConfigs) {
        if (configs == null) {
            return;
        }
        if (!"groupByProjectTime".equals(this.getFilterOptionId())) {
            // 非项目时间分组返回
            return;
        }
        CardListGroupOptionConfigs optionConfigs = new CardListGroupOptionConfigs();
        // 时间
        List<String> time = configs.getTime();
        if (!CollectionUtils.isEmpty(time)) {
            List<CardListOption> timeVO = new ArrayList<>();
            // 选中
            String selectId = Optional.ofNullable(customConfigs).map(CardListGroupOptionConfigs::getTime).orElse(new ArrayList<>())
                    .stream().filter(r -> BooleanUtils.isTrue(r.getIsSelect())).findFirst().map(CardListBaseOption::getFilterOptionId).orElse(null);
            for (String id : time) {
                ConfigsEnum configsEnum = ConfigsEnum.getEnumById(id);
                if (configsEnum != null) {
                    timeVO.add(new CardListOption(configsEnum.getId(), localeService.getLanguageValue(locale, configsEnum.getName()), id.equals(selectId)));
                }
            }
            if (timeVO.stream().noneMatch(r -> BooleanUtils.isTrue(r.getIsSelect()))) {
                // 默认选中第一个
                timeVO.get(0).setIsSelect(true);
            }
            optionConfigs.setTime(timeVO);
        }
        // 日期
        List<String> date = configs.getDate();
        if (!CollectionUtils.isEmpty(date)) {
            List<CardListOption> dateVO = new ArrayList<>();
            // 选中
            String selectId = Optional.ofNullable(customConfigs).map(CardListGroupOptionConfigs::getDate).orElse(new ArrayList<>())
                    .stream().filter(r -> BooleanUtils.isTrue(r.getIsSelect())).findFirst().map(CardListBaseOption::getFilterOptionId).orElse(null);
            for (String id : date) {
                ConfigsEnum configsEnum = ConfigsEnum.getEnumById(id);
                if (configsEnum != null) {
                    dateVO.add(new CardListOption(configsEnum.getId(), localeService.getLanguageValue(locale, configsEnum.getName()), id.equals(selectId)));
                }
            }
            if (dateVO.stream().noneMatch(r -> BooleanUtils.isTrue(r.getIsSelect()))) {
                // 默认选中第一个
                dateVO.get(0).setIsSelect(true);
            }
            optionConfigs.setDate(dateVO);
        }
        this.optionConfigs = optionConfigs;
    }

    @Getter
    public enum ConfigsEnum {
        // time
        BEGIN("begin", "项目开始时间"),
        END("end", "项目结束时间"),
        // date
        MONTH("month", "月维度"),
        YEAR("year", "年维度"),
        ;

        private final String id;
        private final String name;

        ConfigsEnum(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public static ConfigsEnum getEnumById(String id) {
            for (ConfigsEnum configsEnum : ConfigsEnum.values()) {
                if (Objects.equals(configsEnum.getId(), id)) {
                    return configsEnum;
                }
            }
            return null;
        }
    }
}
