package com.digiwin.mobile.mobileuibot.core.component.list.card;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Objects;

/**
 * CARD_LIST组件筛选功能--筛选选项
 *
 * @author zhangjj
 * @date 2022/10/10 10:04
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CardListOption extends CardListBaseOption implements Serializable {
    private static final long serialVersionUID = 2314457290739297452L;

    private Boolean isSelect = false;

    public CardListOption(String filterOptionId, String filterOptionName) {
        this.setFilterOptionId(filterOptionId);
        this.setFilterOptionName(filterOptionName);
    }

    public CardListOption(String filterOptionId, String filterOptionName, boolean isSelect) {
        this.setFilterOptionId(filterOptionId);
        this.setFilterOptionName(filterOptionName);
        this.setIsSelect(isSelect);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CardListOption that = (CardListOption) o;
        return Objects.equals(this.getFilterOptionId(), that.getFilterOptionId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getFilterOptionId());
    }
}
