package com.digiwin.mobile.mobileuibot.core.component.list.card;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.progress.ProgressRate;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * 卡片进度的模型
 *
 * @author zhangjj
 * @date 2021/6/23 0023 11:24
 */
@Data
public class CardProgress extends BaseMobileComponent {
    private static final long serialVersionUID = 4747209338726130410L;
    public static final String COMPONENT_TYPE = "CARD_LIST_PROGRESS";

    @Override
    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    /**
     * app异步请求进度数据时使用的接口url
     */
    private String url;

    /**
     * 进度数据。需要在进度数据的接口url返回给前端
     */
    @JsonProperty("progressRate")
    @JSONField(name = "progressRate")
    private List<ProgressRate> progressRateList;

    /**
     * 进度区域点击时的操作。需要在进度数据的接口url返回给前端
     */
    private Action action;

    /**
     * 进度区域展示的子卡片。需要在进度数据的接口url返回给前端
     */
    private ChildCard childCard;

    public CardProgress() {
    }
}
