package com.digiwin.mobile.mobileuibot.core.component.list.card;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * 高级筛选-条件类型
 *
 * @author xujinc
 * @date 2024/06/04 17:07
 */
@Getter
public enum FilterTypeEnum {

    /**
     * 包含
     */
    INCLUDE("1", "包含", Arrays.asList(DataTypeEnum.STRING.getName(),
            DataTypeEnum.SELECT.getName(),
            (DataTypeEnum.BOOLEAN.getName()))),

    /**
     * 不包含
     */
    NOT_INCLUDE("2", "不包含", Arrays.asList(DataTypeEnum.STRING.getName(),
            DataTypeEnum.SELECT.getName(),
            (DataTypeEnum.BOOLEAN.getName()))),

    /**
     * 等于
     */
    EQUAL("3", "等于",  Arrays.asList(DataTypeEnum.STRING.getName(),
            DataTypeEnum.NUMBER.getName())),

    /**
     * 不等于
     */
    NOT_EQUAL("4", "不等于",  Arrays.asList(DataTypeEnum.STRING.getName(),
            DataTypeEnum.NUMBER.getName())),

    /**
     * 介于
     */
    INTERVENE("5", "介于",  Arrays.asList(DataTypeEnum.DATE.getName(),
            DataTypeEnum.NUMBER.getName())),

    /**
     * 小于
     */
    LESS_THAN("6", "小于",  Arrays.asList(DataTypeEnum.NUMBER.getName())),

    /**
     * 小于等于
     */
    LESS_THAN_OR_EQUAL("7", "小于等于",  Arrays.asList(DataTypeEnum.NUMBER.getName())),

    /**
     * 大于
     */
    GREATER_THAN("8", "大于",  Arrays.asList(DataTypeEnum.NUMBER.getName())),

    /**
     * 大于等于
     */
    GREATER_THAN_OR_EQUAL("9", "大于等于",  Arrays.asList(DataTypeEnum.NUMBER.getName())),

    ;

    private String type;

    private String name;

    private List<String> supportDataType;

    FilterTypeEnum(String type, String name, List<String> supportDataType) {
        this.type = type;
        this.name = name;
        this.supportDataType = supportDataType;
    }

    public static String getNameByType(Integer type) {
        if (Objects.isNull(type)) {
            return StringUtils.EMPTY;
        }
        for (FilterTypeEnum item : FilterTypeEnum.values()) {
            if (type.equals(item.getType())) {
                return item.getName();
            }
        }
        return StringUtils.EMPTY;
    }
}
