package com.digiwin.mobile.mobileuibot.core.component.list.card;

import lombok.Getter;
import org.apache.commons.lang3.BooleanUtils;

import java.util.Arrays;
import java.util.List;

/**
 * 排序-选项值
 *
 * @author xujinc
 * @date 2024/07/04 17:07
 */
@Getter
public enum OrderOptionEnum {

    /**
     * 升序
     */
    ASC("asc", "升序"),

    /**
     * 降序
     */
    DESC("desc", "降序"),

    /**
     * 默认
     */
    DEFAULT("default", "默认"),

    ;

    private String type;

    private String name;


    OrderOptionEnum(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public static List<OrderOptionEnum> getCommonSort(Boolean hasDefault) {
        if (BooleanUtils.isTrue(hasDefault)) {
            return Arrays.asList(OrderOptionEnum.values());
        }
        return Arrays.asList(OrderOptionEnum.ASC, OrderOptionEnum.DESC);
    }
}
