package com.digiwin.mobile.mobileuibot.core.component.list.card;

import lombok.Getter;

import java.util.Objects;

/**
 * <p>功能描述：筛选 页面(task/project/team-tasks/team-projects) 枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PageFilterCodeEnum.java
 * @Author: wangjwc
 * @Date: created at 2024/7/25 10:33
 */
@Getter
public enum PageFilterCodeEnum {
    /**
     * 我的任务
     */
    TASK("task"),
    /**
     * 我的项目
     */
    PROJECT("project"),
    /**
     * 团队任务
     */
    TEAM_TASKS("team-tasks"),
    /**
     * 团队项目
     */
    TEAM_PROJECTS("team-projects"),

    ;

    private final String value;

    PageFilterCodeEnum(String value) {
        this.value = value;
    }

    public static PageFilterCodeEnum getEnumByValue(String value) {
        for (PageFilterCodeEnum codeEnum : PageFilterCodeEnum.values()) {
            if (Objects.equals(codeEnum.getValue(), value)) {
                return codeEnum;
            }
        }
        return null;
    }

    public static boolean isExist(String value) {
        return !isNotExist(value);
    }

    public static boolean isNotExist(String value) {
        return getEnumByValue(value) == null;
    }
}
