package com.digiwin.mobile.mobileuibot.core.component.list.card;

import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

/**
 * 排序-阅读状态选项值
 *
 * @author xujinc
 * @date 2024/08/12 17:07
 */
@Getter
public enum ReadStateOrderOptionEnum {

    /**
     * 未读
     */
    ASC("asc", "未读"),

    /**
     * 已读
     */
    DESC("desc", "已读"),

    ;

    private String type;

    private String name;


    ReadStateOrderOptionEnum(String type, String name) {
        this.type = type;
        this.name = name;
    }


    public static String getReadStateOrderOptionNameByType(String type) {
        Optional<ReadStateOrderOptionEnum> readStateOrderOptionEnumOpt = Arrays.stream(values())
                .filter(e -> e.getType().equals(type))
                .findFirst();
        if (readStateOrderOptionEnumOpt.isPresent()) {
            return readStateOrderOptionEnumOpt.get().getName();
        }
        return "";
    }
}
