package com.digiwin.mobile.mobileuibot.core.component.list.card;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * 高级筛选-分隔类型
 *
 * @author xujinc
 * @date 2024/06/04 17:07
 */
@Getter
public enum SpliceTypeEnum {

    /**
     * 且
     */
    AND("1", "且"),

    /**
     * 或
     */
    OR("2", "或"),

    ;

    private String type;

    private String name;

    SpliceTypeEnum(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public static String getNameByType(Integer type) {
        if (Objects.isNull(type)) {
            return StringUtils.EMPTY;
        }
        for (SpliceTypeEnum item : SpliceTypeEnum.values()) {
            if (type.equals(item.getType())) {
                return item.getName();
            }
        }
        return StringUtils.EMPTY;
    }
}
