package com.digiwin.mobile.mobileuibot.core.component.list.card;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 筛选-系统级筛选条件
 *
 * @author xujinc
 * @date 2024/07/04 17:07
 */
@Getter
public enum SystemFilterEnum {

    /**
     * 任务类型
     */
    TASK_TYPE(DigiwinAtmcBacklog.TASK_TYPE, "任务类型", DataTypeEnum.SELECT.getName(), Collections.emptyMap()),

    /**
     * 任务来源
     */
    TASK_OTHERTASKINFO(DigiwinAtmcBacklog.TASK_OTHERTASKINFO, "任务来源", DataTypeEnum.SELECT.getName(), DigiwinAtmcBacklog.TASK_FLOW_MAP),

    /**
     * 阅读状态
     */
    TASK_READ_STATUS(DigiwinAtmcBacklog.TASK_READ_STATUS, "阅读状态", DataTypeEnum.SELECT.getName(), DigiwinAtmcBacklog.TASK_READ_STATUS_MAP),

    /**
     * 任务状态
     */
    TASK_STATUS(DigiwinAtmcBacklog.TASK_STATUS, "任务状态", DataTypeEnum.SELECT.getName(), DigiwinAtmcBacklog.TASK_STATUS_MAP),

    /**
     * 完成时间
     */
    TASK_DATE_RANGE(DigiwinAtmcBacklog.TASK_DATE_RANGE, "完成时间", DataTypeEnum.DATE.getName(), Collections.emptyMap()),

    ;

    private String type;

    private String name;

    private String dataType;

    private Map<String, String> options;

    public Map<String, String> getOptions(String locale) {
        if (CollectionUtils.isEmpty(options)) {
            return options;
        }
        LocaleService localeService = SpringContextHolder.getBean(LocaleService.class);
        Map<String, String> localeMap = new LinkedHashMap<>();
        options.entrySet().stream().forEach(entry -> localeMap.put(entry.getKey(), localeService.getLanguageValue(locale, entry.getValue())));
        return localeMap;
    }

    SystemFilterEnum(String type, String name, String dataType, Map<String, String> options) {
        this.type = type;
        this.name = name;
        this.dataType = dataType;
        this.options = options;
    }
}
