package com.digiwin.mobile.mobileuibot.core.component.list.container;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.*;
import com.digiwin.mobile.mobileuibot.core.component.adaptivegrid.GridSpacingEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.LayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：列表容器组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ListContainer.java
 * @Author: wangjwc
 * @Date: created at 2025/1/13 13:01
 */
@Data
public class ListContainer extends BaseMobileComponent {
    private static final long serialVersionUID = -2795416208743300451L;
    public static final String COMPONENT_TYPE = "LIST_CONTAINER";
    /**
     * 默认1，布局方式0：水平布局，1：垂直布局
     * @see LayoutTypeEnum
     */
    private Integer layoutType = LayoutTypeEnum.VERTICAL.getValue();
    /**
     * layoutType=0时显示，允许换行，true：是，false：否
     */
    private Boolean allowWrap;
    /**
     * 子项间距： 0：超小，1：小，2：中，3：大，4：超大
     * @see GridSpacingEnum
     */
    private Integer spacing;

    /**
     * 容器间距： 0：超小，1：小，2：中，3：大，4：超大
     * @see GridSpacingEnum
     */
    private Integer margin;
    /**
     * 内容组件(最多只有一个) --- 设计态设计的结构
     */
    @JsonDeserialize(contentUsing = BaseMobileComponentWrapperJsonDeserializer.class)
    private List<BaseMobileComponentWrapper<BaseMobileComponent>> rawContentGroup;

    /**
     * 内容组件 -- 运行态结构
     */
    @JsonDeserialize(contentUsing = BaseMobileComponentWrapperJsonDeserializer.class)
    private List<BaseMobileComponentWrapper<BaseMobileComponent>> contentGroup;

    /**
     * 数据源配置
     */
    private DataSource dataSource;

    @Override
    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                                     PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.resetCmptMultipleDataSourceData(cmptContext, executeContext, this.dataSource, data);
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.handleListContainer(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
    }

    private void handleListContainer(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                                     PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        List<Map<String, Object>> dataList;
        if (data.containsKey(UiBotDesignerRenderService.LIST_MARKER)) {
            // 任务详情页渲染
            if (ZtbViewList.isChildNode(mobilePath, schema)) {
                data.remove(UiBotDesignerRenderService.LIST_MARKER);
                // 详情页，列表是数据源下的一个节点
                mobilePageRawData.setRawMap(data);
                dataList = (List<Map<String, Object>>) UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
            } else {
                // 表示整体数据是数组 -- 不可传入rawMap数据，否则会影响非任务详情页提交按钮中action的rawdata中data数据
                mobilePageRawData.setRawMap(null);
                // 表示整体数据是数组
                dataList = (List<Map<String, Object>>) UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
            }
        } else {
            // 非任务详情页渲染
            mobilePageRawData.setRawMap(data);
            // 表示对象中schema值是是数组
            dataList = (List<Map<String, Object>>) UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
        }

        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }

        this.contentGroup = new ArrayList<>();
        if (!CollectionUtils.isEmpty(dataList) && !CollectionUtils.isEmpty(this.rawContentGroup)) {
            UiBotDesignerRenderService renderService = SpringContextHolder.getBean(UiBotDesignerRenderService.class);
            dataList.forEach(r -> {
                // 拷贝，更改内存地址
                List<BaseMobileComponentWrapper<BaseMobileComponent>> rawContentGroup = JsonUtil.objectToJavaObject(new Layout().setContentGroup(this.rawContentGroup), Layout.class).getContentGroup();
                renderService.buildCmptDsl(cmptContext, executeContext, rawContentGroup, r, mobilePageRawData);
                if (!CollectionUtils.isEmpty(rawContentGroup)) {
                    this.contentGroup.add(rawContentGroup.get(0));
                }
            });
        }

        // clear
        this.rawContentGroup = null;
        this.dataSource = null;
    }

    @Data
    @Accessors(chain = true)
    private static class Layout {
        @JsonDeserialize(contentUsing = BaseMobileComponentWrapperJsonDeserializer.class)
        private List<BaseMobileComponentWrapper<BaseMobileComponent>> contentGroup;
    }
}