package com.digiwin.mobile.mobileuibot.core.component.list.editcardlist;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.CommonRawDataParentType;
import com.digiwin.mobile.mobileuibot.core.component.*;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParamJsonDeserializer;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonGroup;
import com.digiwin.mobile.mobileuibot.core.component.card.card.BaseCard;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.chart.mobilechart.*;
import com.digiwin.mobile.mobileuibot.core.component.input.addersubstracter.AdderSubstracter;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.input.sign.InputSign;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.ButtonSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListChoiceEnum;
import com.digiwin.mobile.mobileuibot.core.component.progressbar.ProgressBar;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItemCardDetailPage;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * <p>功能描述：标准编辑卡片组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: EditCard.java
 * @Author: wangjwc
 * @Date: created at 2024/5/9 16:24
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class EditCard extends BaseCard {
    private static final long serialVersionUID = -4621494152588964620L;
    public static final String COMPONENT_TYPE = "EDIT_CARD";

    /**
     * 批量提交时，解析的参数结构
     */
    @JsonDeserialize(contentUsing = ActionSubmitParamJsonDeserializer.class)
    private List<ActionSubmitParam> submitParams;

    private String title;
    private String subTitle;
    private Action subTitleAction;
    // 卡片本身点击事件，不会左右划动
    private Action cardAction;
    private String dataId;
    private Map<String, Object> rawData;
    // 1.通用样式；2.全部置灰样式, 3: 标题和内容区块分层颜色(通过titleBgColor来指定颜色)
    private Integer style = 1;
    private String titleBgColor;
    @JsonDeserialize(contentUsing = BaseMobileComponentWrapperJsonDeserializer.class)
    private List<BaseMobileComponentWrapper<BaseMobileComponent>> contentGroup;
    private List<Tag> tags;
    private TabItemCardDetailPage detailPage;

    /**
     * 用于是否打开卡片详情页，默认false，
     * 如果卡片上无编辑类型的组件的时候为true
     */

    private Boolean openCardDetailPage = false;
    /**
     * 内容布局类型
     *
     * @see CardLayoutTypeEnum
     */
    private Integer layoutType = CardLayoutTypeEnum.DEFAULT.getValue();
    private Picture cardPicture;
    @JsonDeserialize(contentUsing = BaseMobileComponentWrapperJsonDeserializer.class)
    private List<BaseMobileComponentWrapper<BaseMobileComponent>> cardButtons;
    // 把editCardList中的属性冗余在editCard中
    private String choice = MultiFunctionListChoiceEnum.NO_CHOICE.name();
    /**
     * 卡片折叠或者收起，true 为展开，false 为收起。默认收起
     */
    private Boolean defaultFolded = false;

    /**
     * 折叠类型，0全部折叠，1 部分折叠
     */
    private Integer foldedType;

    /**
     * 最大个数显示,默认展示2个
     */
    private Integer maxContentDisplay = 2;

    /**
     * 0(默认)点击卡片和按钮都能进详情、
     * 1点击整个卡片(除按钮外)进详情 、
     * 2点击按钮进详情(且当卡片上的某个按钮action==null时点击按钮触发)
     */
    private Integer openDetailType = 0;


    public List<BaseMobileComponentWrapper<BaseMobileComponent>> getCardButtons() {
        if (this.cardButtons == null) {
            this.cardButtons = Card.buildCardButton(this.data);
        }
        return cardButtons;
    }

    /**
     * 公共参数（需要把该参数里面的数据塞到对应的rawData里面） --- 后期优化独立card时会使用此属性
     * ---- 注意：需要考虑独立卡片还是CardList下卡片。因CardList下也有对应的公共参数
     * 1、存储卡片的detailPage中RawData公共部分
     * 2、存储卡片的跳转类按钮中RawData公共部分
     */
    private Map<String, Object> commonChildRawData;

    /**
     * 设计态设计的card 结构---原始结构
     */
    private Card.DesignerRawCard data;

    @Override
    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public void beforeHandleAttribute(Integer buttonLayoutType) {
        List<BaseMobileComponentWrapper<BaseMobileComponent>> cardButtons = this.getCardButtons();
        if (CollectionUtils.isEmpty(cardButtons)) {
            return;
        }
        BaseMobileComponentWrapper<BaseMobileComponent> wrapper = cardButtons.get(0);
        if (wrapper.getData() instanceof ButtonGroup) {
            ButtonGroup buttonGroup = (ButtonGroup) wrapper.getData();
            if (buttonGroup != null) {
                buttonGroup.setButtonLayoutType(buttonLayoutType);
            }
        }
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                                     PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        boolean notExist = cmptContext.getCommonRawDataParentType() == null;
        if (notExist) {
            super.resetCmptMultipleDataSourceData(cmptContext, executeContext, Optional.ofNullable(this.data).map(Card.DesignerRawCard::getDataSource).orElse(null), data);
            cmptContext.setCommonRawDataParentType(CommonRawDataParentType.ALONE_CARD.getValue());
        }
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.handleEditCard(cmptContext, data, executeContext, mobilePageRawData);
        this.commonChildRawData = Card.buildCommonChildRawData(cmptContext, executeContext, mobilePageRawData);
        if (notExist) {
            cmptContext.setCommonRawDataParentType(null);
        }
    }

    private void handleEditCard(ComponentContext cmptContext, Map<String, Object> data,
                                PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        this.mobilePath = this.data.getNodePath();
        this.schema = StringUtils.hasLength(cmptContext.getModifyCardDataId()) ? cmptContext.getModifyCardDataId() : Card.buildCardSchema(this.data, data);
        if (StringUtils.hasLength(this.componentId)) {
            // 单独的editcard组件
            this.cmptUuid = this.componentId;
        } else {
            // 说明是editcardList组件中的editcard
            this.cmptUuid = this.componentId = this.schema;
        }
        this.title = Card.handleCardTitle(this.data, data, false, this.title, executeContext).trim();
        this.style = this.data.getStyle();
        this.titleBgColor = "3".equals(StringUtil.valueOf(this.data.getStyle())) ? this.data.getTitleBgColor() : null;
        this.subTitle = Card.handleCardSubTitle(this.data, data).trim();
        this.subTitleAction = Card.buildSubTitleAction(this.data, data, this.getSchema(), executeContext, mobilePageRawData, cmptContext);
        this.detailPage = Card.buildDetailPage(this.data, data, this.getSchema(), executeContext, mobilePageRawData, cmptContext);
        this.openCardDetailPage = Card.buildOpenCardDetailPage(this.data, this.detailPage);
        this.cardAction = Card.buildCardAction(this.data, this.openCardDetailPage, this.data.getOpenDetailType(), this.detailPage, cmptContext);
        this.contentGroup = this.buildContentGroup(this.data, cmptContext, data, executeContext, mobilePageRawData);
        this.tags = Card.buildTags(this.data.getContent(), data, executeContext.getTmActivityId());
        this.layoutType = this.data.getLayoutType();
        this.openDetailType = this.data.getOpenDetailType();
        //处理卡片折叠相关
        this.defaultFolded = this.data.getDefaultFolded();
        this.foldedType = this.data.getFoldedType();
        this.maxContentDisplay = this.data.getMaxContentDisplay();
        this.cardPicture = Card.buildCardPicture(this.data, data);
        // card卡片的dataid设置一个唯一值，作用于详情页保存后更新原始数据查找的标志，与card的按钮、detailPage的dataid相同
        this.dataId = this.getSchema();
        // 用于批量提交参数替换，识别是哪个条目的id
        data.put(PcUiBotConstants.MOBILE_CARD_DATAID_KEY, this.dataId);
        if (!CollectionUtils.isEmpty(this.cardButtons)) {
            // card中的按钮dataid，设置和card中detailPage中dataid相同
            UiBotDesignerRenderService uiBotDesignerRenderService = SpringContextHolder.getBean(UiBotDesignerRenderService.class);
            uiBotDesignerRenderService.buildCmptDsl(cmptContext, executeContext, this.cardButtons, data, mobilePageRawData.deepCopy().setDataId(this.getSchema()));
        }
        this.rawData = data;
        // clear
        this.data = null;
    }

    public static List<BaseMobileComponentWrapper<BaseMobileComponent>> buildContentGroup(Card.DesignerRawCard designerRawCard, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        List<BaseMobileComponentWrapper<BaseMobileComponent>> contentGroup = new ArrayList<>();
        List<Card.DesignerRawCard.Content> rawContentList = designerRawCard.getContent();
        if (CollectionUtils.isEmpty(rawContentList)) {
            return contentGroup;
        }
        for (Card.DesignerRawCard.Content rawContent : rawContentList) {
            BaseMobileComponent baseMobileComponent = null;
            // 编辑类卡片：除cardContent能力范围外的组件，如图片、附件、开窗、日期、开关、按钮、进度条 以对应组件返回
            switch (rawContent.getType()) {
                case "TAG":
                    // 标签 --- 作用于卡片的标签栏位，不在此处处理
                    break;
                case "DW_SHOW_PICTURE":
                    // 显示图片 --- 作用于卡片的左图或右图，不在此处处理
                    break;
                case "DW_PICTURE":
                    // 图片拍照 --- 暂无场景使用
                    baseMobileComponent = Picture.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                    break;
                case "FILE_UPLOAD":
                    // 附件上传
                    baseMobileComponent = Attachment.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                    break;
                case "OPENWINDOW":
                    // 文本开窗
                    Card.DesignerRawCard.Content.OpenWindowSelectObj openWindowSelectObj = JsonUtil.objectToJavaObject(rawContent.getSetting(), Card.DesignerRawCard.Content.OpenWindowSelectObj.class);
                    //是否多选
                    if (Objects.nonNull(openWindowSelectObj) && BooleanUtils.isTrue(openWindowSelectObj.getIsMulti())) {
                        baseMobileComponent = InputWindowMultiSelect.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                    } else {
                        baseMobileComponent = InputWindowSingleSelect.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                    }
                    break;
                case "DW_INPUT_DATETIME_PICKER":
                    // 日期
                    baseMobileComponent = InputDateTimePicker.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                    break;
                case "DW_INPUT_SWITCH":
                    // 开关
                    baseMobileComponent = InputSwitch.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                    break;
                case "DW_BUTTON_SINGLE_SELECT":
                    // 按钮单选
                    baseMobileComponent = ButtonSingleSelect.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                    break;
                case "DW_PROGRESS_BAR":
                    // 进度条组件
                    baseMobileComponent = ProgressBar.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                    break;
                case "DW_INPUT_SIGN":
                    // 签名组件
                    baseMobileComponent = InputSign.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                    break;
                case "DW_ADDER_SUBSTRACTER":
                    // 加减器组件
                    baseMobileComponent = AdderSubstracter.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                    break;
                case "DW_CHART_INDICATOR":
                    // 指标卡图表
                    baseMobileComponent = IndicatorChart.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                    break;
                case "DW_CHART_SUBPROGRESS":
                    // 子项进度图表
                    baseMobileComponent = SubProgressChart.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                    break;
                case "DW_CHART_PIE":
                    // 饼图图表
                    baseMobileComponent = PieChart.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                    break;
                case "DW_CHART_LINE":
                    // 折线图
                    baseMobileComponent = LineChart.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                    break;
                case "DW_CHART_BAR":
                    // 柱状图
                    baseMobileComponent = BarChart.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                    break;
                case "DW_CHART_DASHBOARD":
                    // 仪表盘
                    baseMobileComponent = DashboardChart.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                    break;
                case "DW_CHART_RADAR":
                    // 雷达图
                    baseMobileComponent = RadarChart.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                    break;
                default:
                    // 其它组件，如电话号码、枚举、数值、文本、文本域，编辑时返回对应组件，只读时返回cardContent组件
                    if (BooleanUtils.isTrue(rawContent.getEditable())) {
                        // 编辑
                        switch (rawContent.getType()) {
                            case "DW_MOBILE_TEL":
                                // 电话号码
                                baseMobileComponent = InputSingleText.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                                break;
                            case "ENUM":
                                // 枚举
                                Card.DesignerRawCard designerRawCardNew = JsonUtil.objectToJavaObject(designerRawCard, Card.DesignerRawCard.class);
                                designerRawCardNew.setContent(Lists.newArrayList(rawContent));
                                List<CardContent> cardContents = new Card().buildContent(designerRawCardNew, data, executeContext, mobilePageRawData);
                                // 处理卡片内容的高级属性
                                cardContents.forEach(r -> r.handleComponentParam(cmptContext, r.getMobilePath(), r.getSchema(), data, executeContext, mobilePageRawData));
                                if (!CollectionUtils.isEmpty(cardContents)) {
                                    baseMobileComponent = cardContents.get(0);
                                }
                                break;
                            case "NUMERICAL":
                                // 数值
                                baseMobileComponent = InputNumeric.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                                break;
                            case "LABEL":
                                // 文本
                                baseMobileComponent = InputSingleText.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                                break;
                            case "DW_INPUT_MULTI":
                                // 文本域
                                baseMobileComponent = InputMultiText.cardContentConvertComponent(rawContent, cmptContext, data, executeContext, mobilePageRawData);
                                break;
                            default:
                                break;
                        }
                    } else {
                        // 只读
                        Card.DesignerRawCard designerRawCardNew = JsonUtil.objectToJavaObject(designerRawCard, Card.DesignerRawCard.class);
                        designerRawCardNew.setContent(Lists.newArrayList(rawContent));
                        List<CardContent> cardContents = new Card().buildContent(designerRawCardNew, data, executeContext, mobilePageRawData);
                        // 处理卡片内容的高级属性
                        cardContents.forEach(r -> r.handleComponentParam(cmptContext, r.getMobilePath(), r.getSchema(), data, executeContext, mobilePageRawData));
                        if (!CollectionUtils.isEmpty(cardContents)) {
                            baseMobileComponent = cardContents.get(0);
                        }
                    }
                    break;
            }
            if (baseMobileComponent != null) {
                contentGroup.add(new BaseMobileComponentWrapper<>(baseMobileComponent, "DW_" + baseMobileComponent.returnComponentType(), rawContent.getSchema(), rawContent.getFullPath()));
            }
        }
        return contentGroup;
    }


}