package com.digiwin.mobile.mobileuibot.core.component.list.editcardlist;

import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.CommonRawDataParentType;
import com.digiwin.mobile.mobileuibot.core.component.*;
import com.digiwin.mobile.mobileuibot.core.component.action.*;
import com.digiwin.mobile.mobileuibot.core.component.button.*;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardOpenDetailTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardProcessedCondition;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListChoiceEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmPageOperationService;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

import static com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils.localeService;

/**
 * <p>功能描述：标准编辑卡片列表组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: EditCardList.java
 * @Author: wangjwc
 * @Date: created at 2024/5/9 15:21
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class EditCardList extends BaseMobileComponent {
    private static final long serialVersionUID = -7847732461020697756L;
    public static final String COMPONENT_TYPE = "EDIT_CARD_LIST";

    public static final Map<String, Integer> operationMap;
    public static final Map<String, String> iconNameMap;

    static {
        operationMap = new HashMap<>();
        operationMap.put("upload_file", ActionTypeEnum.OPEN_NEW_PAGE_FROM_IMPORT.getValue());
        operationMap.put("data_export", ActionTypeEnum.OPEN_NEW_PAGE_FROM_EXPORT_ALL.getValue());
        operationMap.put("download_template", ActionTypeEnum.OPEN_NEW_PAGE_FROM_DOWNLOAD.getValue());
        operationMap.put("data_export_1", ActionTypeEnum.OPEN_NEW_PAGE_FROM_EXPORT.getValue());
        iconNameMap = new HashMap<>();
        iconNameMap.put("upload_file", ActionIconNameEnum.IMPORT.getValue());
        iconNameMap.put("data_export", ActionIconNameEnum.EXPORT_ALL.getValue());
        iconNameMap.put("download_template", ActionIconNameEnum.DOWNLOAD.getValue());
        iconNameMap.put("data_export_1", ActionIconNameEnum.EXPORT.getValue());

    }

    /**
     * 提交时，解析的参数结构
     */
    @JsonDeserialize(contentUsing = ActionSubmitParamJsonDeserializer.class)
    private List<ActionSubmitParam> submitParams;

    /**
     * 标题是否显示，true：显示，false：隐藏
     */
    private Boolean titleVisible = false;
    private String title;
    @JsonDeserialize(contentUsing = BaseMobileComponentWrapperJsonDeserializer.class)
    protected List<BaseMobileComponentWrapper<BaseMobileComponent>> contentGroup;

    /**
     * 设计态设计的card 结构---原始结构
     */
    private Card cardListData;

    /**
     * 设计器：新增card按钮开关
     */
    private Boolean canAddOrEditCard;
    /**
     * 设计器：新增card按钮：设计态设计的结构
     */
    private UiBotAction addCardButton;
    /**
     * 前端使用 V2版DSL，新增按钮Action
     */
    private Action addItemAction;

    /**
     * 底部是否展示新增数据按钮，true为展示，false为隐藏，默认为false
     */
    private Boolean canShowBottom = false;
    /**
     * 前端使用：新增card所有数据
     */
    private List<ActionSubmitParam> cardAllDataList;
    /**
     * 是否整批提交场景  true：是，false：否
     * 前端根据此字段判断cardList组件是否是整批提交，true：条目详情页底部按钮暂存/保存并提交按钮控制
     * 只使用于line场景
     */
    private Boolean isAllSubmitScene = false;

    /**
     * 前端使用 V2版DSL，转表格按钮Action，null表示未开启
     */
    private Action tableAction;

    /**
     * 设计器：是否支持筛选
     */
    private Boolean canFilterCard = false;
    /**
     * 设计器：筛选按钮
     */
    private UiBotAction filterCardButton;
    /**
     * 运行态：V2版DSL，新增按钮Action
     */
    private Action filterAction;
    // 是否是筛选后的数据/是否首次默认弹出筛选框(filterFlag=false)
    private Boolean filterFlag;
    // 当前列表过滤条件
    private Map<String, Object> filterCondition;
    /**
     * 设计器 是否首次展示筛选
     */
    private Boolean showInitFilter = false;

    /**
     * @see com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListChoiceEnum
     */
    private String choice = MultiFunctionListChoiceEnum.NO_CHOICE.name();
    /**
     * 新增card模板,只取第一个
     */
    @JsonDeserialize(contentUsing = BaseMobileComponentWrapperJsonDeserializer.class)
    private List<BaseMobileComponentWrapper<BaseMobileComponent>> contentTemplates;
    /**
     * 设计器新增属性，card底部按钮布局类型
     * 1:折叠 2:平铺
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.button.ButtonLayoutTypeEnum
     */
    private Integer buttonLayoutType = ButtonLayoutTypeEnum.FOLD.getValue();
    /**
     * 当前卡片列表是否校验 true：校验，false：不校验
     * 用于底部按钮是否校验卡片，使其高亮可点击
     */
    private Boolean isCheckList = false;

    /**
     * 设计器新增属性--添加card方式类型--默认1
     * 1：开弹窗或页面新增数据（默认），2：使用模板在当前页面新增数据
     * 注意：新增卡片场景下有效，并只在编辑的卡片列表中有效
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.AddCardTypeEnum
     */
    private Integer addCardType = AddCardTypeEnum.OPEN_PAGE_ADD.getValue();

    /**
     * 公共参数（需要把该参数里面的数据塞到对应的rawData里面）
     * 1、存储卡片列表下卡片的detailPage中RawData公共部分
     * 2、存储卡片列表下卡片的跳转类按钮中RawData公共部分
     */
    private Map<String, Object> commonChildRawData;

    /**
     * 设计器搜索--是否支持搜索
     */
    private Boolean canSearch = false;

    /**
     * 设计器搜索-设计态
     */
    private ZtbViewList.RawSearchConfig rawSearchConfig;

    /**
     * 设计器搜索-运行态
     */
    private ZtbViewList.SearchConfig searchConfig;

    /**
     * 操作按钮集合
     */
    private List<PcUiBotTmOperation> operations;

    /**
     * 返回给前端的
     */
    @JsonDeserialize(contentUsing = BaseMobileComponentWrapperJsonDeserializer.class)
    private List<BaseMobileComponentWrapper<BaseMobileComponent>> operationButtons;

    /**
     * 是否存在导入操作
     */
    private Boolean hasOperationImport = false;

    //是否可滑动查看其他卡片详情,默认fasle
    private Boolean detailPageSwiper = false;

    /**
     * 设计器查询配置
     */
    private PcUiBotQueryInfo queryInfo;
    /**
     * 运行态分页配置
     */
    private ZtbViewList.PagingConfig pagingConfig;

    @Override
    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public Action getAddItemAction(ComponentContext cmptContext, String mobilePath, String schema, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        if (BooleanUtils.isTrue(canAddOrEditCard)) {
            Button<UiBotAction> button = new Button<>();
            button.setSubmitAction(this.addCardButton);
            // 新增按钮暂不优化
            cmptContext.setCommonRawDataParentType(null);
            // 按钮组件
            button.handleComponentParam(cmptContext, mobilePath, schema, new HashMap<>(), executeContext, mobilePageRawData);
            cmptContext.setCommonRawDataParentType(CommonRawDataParentType.ALONE_LIST.getValue());
            // 卡片列表新增按钮清空dataId数据，处理三级页面本地保存时存在的问题
            button.getAction().setDataId("");
            this.addItemAction = button.getAction();
        }

        return addItemAction;
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                                     PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.resetCmptMultipleDataSourceDataAndQueryInfo(cmptContext, executeContext, Optional.ofNullable(this.cardListData).map(Card::getData).map(Card.DesignerRawCard::getDataSource).orElse(null), data, this.queryInfo);
        cmptContext.setCommonRawDataParentType(CommonRawDataParentType.ALONE_LIST.getValue());
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.handleEditCardList(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.commonChildRawData = ZtbViewList.buildCommonChildRawData(executeContext, mobilePageRawData);
        cmptContext.setCommonRawDataParentType(null);
    }

    private void handleEditCardList(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                                    PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        // 设计器配置标题隐藏时，设置title为空字符串，flutter端根据标题为空默认隐藏
        this.title = BooleanUtils.isTrue(this.titleVisible) ? this.title : "";
        ZtbViewList.handleRawCardListData(this.cardListData, executeContext, mobilePageRawData);
        List<Map<String, Object>> dataList;
        if (data.containsKey(UiBotDesignerRenderService.LIST_MARKER)) {
            // 任务详情页渲染
            if (ZtbViewList.isChildNode(mobilePath, schema)) {
                data.remove(UiBotDesignerRenderService.LIST_MARKER);
                // 详情页，列表是数据源下的一个节点
                mobilePageRawData.setRawMap(data);
                dataList = (List<Map<String, Object>>) UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
            } else {
                // 表示整体数据是数组 -- 不可传入rawMap数据，否则会影响非任务详情页提交按钮中action的rawdata中data数据
                mobilePageRawData.setRawMap(null);
                if (BooleanUtils.isTrue(isAllSubmitScene)) {
                    // 存储全量数据 -- 只针对于列表
                    mobilePageRawData.setAllRawMap(data);
                }
                // 表示整体数据是数组
                dataList = (List<Map<String, Object>>) UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
            }
        } else {
            // 非任务详情页渲染
            mobilePageRawData.setRawMap(data);
            // 表示对象中schema值是是数组
            dataList = (List<Map<String, Object>>) UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
        }

        // 筛选
        if (BooleanUtils.isTrue(canFilterCard)) {
            // 获取表数据 user_card_list_filter
            Map<String, Object> userCardListFilterData = ZtbViewList.getUserCardListFilterData(this.filterCardButton, this.componentId, executeContext);
            this.filterCondition = userCardListFilterData;

            Button<UiBotAction> button = new Button<>();
            button.setSubmitAction(this.filterCardButton);
            // 筛选按钮暂不优化
            cmptContext.setCommonRawDataParentType(null);
            // 按钮组件
            button.handleComponentParam(cmptContext, mobilePath, schema, userCardListFilterData, executeContext, mobilePageRawData.deepCopy().setComponentId(this.componentId));
            cmptContext.setCommonRawDataParentType(CommonRawDataParentType.ALONE_LIST.getValue());
            this.filterAction = button.getAction();
            this.filterFlag = !CollectionUtils.isEmpty(userCardListFilterData);
            if (!this.filterFlag) {
                // filterFlag=false,首次默认弹出筛选框，控制当前页面下只有一个为false
                if (BooleanUtils.isFalse(cmptContext.getCardListGlobalFilterFlag())) {
                    this.filterFlag = true;
                } else {
                    // filterFlag 为false 首次进来就会默认展示筛选
                    this.filterFlag = BooleanUtils.isTrue(showInitFilter) ? false : true;
                    if (BooleanUtils.isFalse(this.filterFlag)) {
                        cmptContext.setCardListGlobalFilterFlag(false);
                    }
                }
                if (BooleanUtils.isTrue(showInitFilter)) {
                    // 默认弹起筛选页面时，不展示cardList
                    dataList = new ArrayList<>();
                }
            }

            // cardList 数据 筛选逻辑处理
            dataList = ZtbViewList.handleDataFiltration(dataList, userCardListFilterData);
        }

        // 构建table
        this.tableAction = null;

        // 构建分页配置
        this.pagingConfig = ZtbViewList.buildPagingConfig(cmptContext, executeContext, mobilePageRawData, this.cardListData,
                this.queryInfo, this.getComponentId(), this.returnComponentType());

        // 构建搜索配置
        this.searchConfig = ZtbViewList.handleSearchConfig(cmptContext, executeContext, mobilePageRawData, this.cardListData,
                this.canSearch, this.rawSearchConfig, this.getComponentId(), this.returnComponentType());
        if (this.searchConfig == null) {
            this.canSearch = false;
        }

        // 构建操作按钮
        this.operationButtons = buildOperationButtons(this.cardListData, executeContext, cmptContext, this.operations, mobilePageRawData, data, this.choice);

        this.hasOperationImport = isExistImport(operationButtons);

        //工具栏【新增按钮】数据格式转换
        convertCardListAdd(this.operations);

        if (BooleanUtils.isNotTrue(showInitFilter) && BooleanUtils.isNotTrue(canAddOrEditCard) && CollectionUtils.isEmpty(dataList)) {
            return;
        }

        // card构建
        this.contentGroup = new ArrayList<>();
        if (!CollectionUtils.isEmpty(dataList)) {

            // 卡片按钮的滑动特效开启处理
            handleCardButtonDetailPageSwiper();

            //卡片列表高级属性中，点击事件（onTap），标题点击事件（onTitleTap），子标题点击事件（onSubTitleTap） 目前设计器只能配置在cardList级别，但是运行态需要添加在每个卡片的高级属性中
            Map<String, Object> configCardListButBelongCardHooks;
            if (!CollectionUtils.isEmpty(this.getHooks())) {
                List<String> supportConfigCardListButBelongCard = Lists.newArrayList("onTap", "onTitleTap", "onSubTitleTap");
                configCardListButBelongCardHooks = this.getHooks().entrySet().stream().filter(entry -> supportConfigCardListButBelongCard.contains(entry.getKey()))
                        .collect(Collectors.toMap(entry -> entry.getKey(), entry -> entry.getValue(), (v1, v2) -> v1));
            } else {
                configCardListButBelongCardHooks = null;
            }

            dataList.forEach(r -> {
                // 拷贝，更改内存地址
                EditCard editCard = JsonUtil.objectToJavaObject(this.cardListData, EditCard.class);
                editCard.setChoice(this.choice);
                editCard.beforeHandleAttribute(this.buttonLayoutType);
                editCard.handleComponentParam(cmptContext, null, null, r, executeContext, mobilePageRawData);

                // 点击事件（onTap），标题点击事件（onTitleTap），子标题点击事件（onSubTitleTap）添加到每个卡片的高级属性中
                if (!CollectionUtils.isEmpty(configCardListButBelongCardHooks)) {
                    if (Objects.isNull(editCard.getHooks())) {
                        Map<String, Object> hooks = new HashMap<>();
                        hooks.put("eventSourceType", "component");
                        hooks.put("eventSource", editCard.getCmptUuid());
                        hooks.putAll(configCardListButBelongCardHooks);
                        editCard.setHooks(hooks);
                    } else {
                        editCard.getHooks().putAll(configCardListButBelongCardHooks);
                    }
                }

                this.contentGroup.add(new BaseMobileComponentWrapper<>(editCard, "DW_" + EditCard.COMPONENT_TYPE, editCard.getSchema(), editCard.getMobilePath()));
            });
        }

        // editcardList 新增
        if (BooleanUtils.isTrue(canAddOrEditCard)) {
            if (AddCardTypeEnum.OPEN_PAGE_ADD.getValue().equals(this.addCardType)) {
                // 开弹窗或页面新增数据
                this.getAddItemAction(cmptContext, mobilePath, schema, executeContext, mobilePageRawData);
                List<ActionSubmitParam> cardList = new ArrayList<>();
                if (!CollectionUtils.isEmpty(this.contentGroup)) {
                    this.contentGroup.forEach(wrapper -> {
                        EditCard component = (EditCard) wrapper.getData();
                        EditCard editCard = new EditCard();
                        editCard.setDataId(component.getDataId());
                        editCard.setRawData(component.getRawData());
                        ActionSubmitParam actionSubmitParam = new ActionSubmitParam(component.getDataId(),
                                "DW_" + EditCard.COMPONENT_TYPE, component.getSchema(), component.getMobilePath(), editCard);
                        cardList.add(actionSubmitParam);
                    });
                } else {
                    // 单身新增没有元数据，新增一条，为了使UiBotDesignerRenderService.handleAddCardListDataOfPageData方法中getSubmitParams有值，并需根据type与params=null移除
                    ActionSubmitParam actionSubmitParam = new ActionSubmitParam(null, "DW_" + EditCard.COMPONENT_TYPE, schema, mobilePath, null);
                    cardList.add(actionSubmitParam);
                }
                cmptContext.getCardAllDataList().addAll(cardList);
                this.cardAllDataList = cmptContext.getCardAllDataList();
            } else if (AddCardTypeEnum.TEMPLATE_ADD.getValue().equals(this.addCardType)) {
                // 使用模板在当前页面新增数据
                this.contentTemplates = Lists.newArrayList(this.buildContentTemplate(this.cardListData, cmptContext, executeContext, mobilePageRawData));
            }
        } else {
            List<ActionSubmitParam> cardList = new ArrayList<>();
            if (!CollectionUtils.isEmpty(this.contentGroup)) {
                this.contentGroup.forEach(wrapper -> {
                    EditCard component = (EditCard) wrapper.getData();
                    EditCard editCard = new EditCard();
                    editCard.setDataId(component.getDataId());
                    editCard.setRawData(component.getRawData());
                    ActionSubmitParam actionSubmitParam = new ActionSubmitParam(component.getDataId(),
                            "DW_" + EditCard.COMPONENT_TYPE, component.getSchema(), component.getMobilePath(), editCard);
                    cardList.add(actionSubmitParam);
                });
            }
            cmptContext.getCardAllDataList().addAll(cardList);
            this.cardAllDataList = cmptContext.getCardAllDataList();
        }

        this.isCheckList = this.getIsCheckList(this.cardListData, this.isCheckList);


        // 底部按钮相关的配置
        cmptContext.setChoice(this.choice);
        if (BooleanUtils.isNotTrue(cmptContext.getAddAllSelectButton())) {
            if (MultiFunctionListChoiceEnum.MULTIPLE_CHOICE.name().equals(this.choice)) {
                // 多选下，自动渲染全选按钮
                cmptContext.setAddAllSelectButton(true);
            }
        }

        // clear
        this.cardListData = null;
        this.filterCardButton = null;
        this.addCardButton = null;
        this.queryInfo = null;
        this.rawSearchConfig = null;
    }

    public static List<BaseMobileComponentWrapper<BaseMobileComponent>> buildOperationButtons(Card cardListData, PcUiBotExecuteContext executeContext, ComponentContext cmptContext, List<PcUiBotTmOperation> operations,
                                                                                              MobilePageRawData mobilePageRawData, Map<String, Object> data, String choice) {
        if (ObjectUtils.isEmpty(operations)) {
            return Collections.emptyList();
        }
        //保留非下载，导出，导入工具栏按钮
        List<PcUiBotTmOperation> generalOperations = new ArrayList<>();
        Iterator<PcUiBotTmOperation> iterator = operations.iterator();
        while (iterator.hasNext()) {
            PcUiBotTmOperation operation = iterator.next();
            if (operationMap.containsKey(operation.getType())) {
                if (Objects.equals(operation.getTarget(), executeContext.getMainDataSourceName())) {
                    generalOperations.add(operation);
                }
                iterator.remove();
            }
        }
        //非主表没有对应按钮或者操作按纽栏为空
        if (!Objects.equals(cardListData.getData().getNode(), executeContext.getMainDataSourceName())
                || generalOperations.isEmpty()) {
            return Collections.emptyList();
        }
        TmPageOperationService tmPageOperationService = SpringContextHolder.getBean(TmPageOperationService.class);
        if (ObjectUtils.isEmpty(cmptContext.getPageDefine())) {
            PcUiBotPageDefine pageDefine = new PcUiBotPageDefine();
            cmptContext.setPageDefine(pageDefine);
        }
        tmPageOperationService.createOperations(executeContext, cmptContext.getPageDefine(), null, generalOperations);
        List<PcUiBotOperationDTO> operationsList = cmptContext.getPageDefine().getOperations();
        if (CollectionUtils.isEmpty(operationsList)) {
            return Collections.emptyList();
        }
        //构建按钮
        return buildButtonGroup(operationsList, choice, executeContext, cmptContext, mobilePageRawData, data);
    }

    public static List<BaseMobileComponentWrapper<BaseMobileComponent>> buildButtonGroup(List<PcUiBotOperationDTO> operationsList, String choice,
                                                                                         PcUiBotExecuteContext executeContext, ComponentContext cmptContext,
                                                                                         MobilePageRawData mobilePageRawData, Map<String, Object> data) {
        ButtonGroup buttonGroup = new ButtonGroup();
        List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> contentGroup = new ArrayList<>();
        buttonGroup.setContentGroup(contentGroup);
        BaseMobileComponentWrapper<BaseMobileComponent> componentWrapper =
                new BaseMobileComponentWrapper<>(buttonGroup, "DW_" + ButtonGroup.COMPONENT_TYPE);
        operationsList.forEach(item -> {
            BottomButtonDigiwinAthena button = createButton(executeContext, item);
            contentGroup.add(new BaseMobileComponentWrapper<>(button,
                    "DW_" + Button.COMPONENT_TYPE,
                    UUIDUtil.getUuid()));
            // 多选下，自动创建部分导出按钮组
            if (Objects.equals(ActionTypeEnum.OPEN_NEW_PAGE_FROM_EXPORT_ALL.getValue(), operationMap.get(item.getType()))) {
                if (MultiFunctionListChoiceEnum.MULTIPLE_CHOICE.name().equals(choice)) {
                    BottomButtonDigiwinAthena mulButton = createButton(executeContext, item);
                    mulButton.getSubmitAction().setTitle(localeService.getLanguageValue(executeContext.getLocale(), "数据导出(选中)"));
                    mulButton.getSubmitAction().getJumpAction().setType(operationMap.get("data_export_1"));
                    mulButton.getSubmitAction().getJumpAction().setIconName(iconNameMap.get("data_export_1")); // 注意：这里可能需要额外的逻辑来确定正确的跳转类型
                    contentGroup.add(new BaseMobileComponentWrapper<>(mulButton,
                            "DW_" + Button.COMPONENT_TYPE,
                            UUIDUtil.getUuid()));
                }
            }

        });
        if (!CollectionUtils.isEmpty(contentGroup)) {
            for (BaseMobileComponentWrapper<BottomButtonDigiwinAthena> wrapper : contentGroup) {
                Button<ButtonRawData> button = wrapper.getData();
                button.handleComponentParam(cmptContext, wrapper.getMobilePath(), wrapper.getSchema(), data, executeContext, mobilePageRawData);
            }
        }
        return Lists.newArrayList(componentWrapper);
    }

    //创建button
    public static BottomButtonDigiwinAthena createButton(PcUiBotExecuteContext executeContext, PcUiBotOperationDTO operationDTO) {
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        UiBotAction action = new UiBotAction();
        UiBotJumpAction jumpAction = new UiBotJumpAction();
        jumpAction.setType(operationMap.get(operationDTO.getType()));
        jumpAction.setIconName(iconNameMap.get(operationDTO.getType()));
        Map<String, Object> rawData = new HashMap<>();
        if (ObjectUtils.isNotEmpty(operationDTO.getExtendedFields())) {
            rawData.put("actionId", operationDTO.getExtendedFields().get("actionId"));
        }
        if (ObjectUtils.isNotEmpty(operationDTO.getAttach())) {
            rawData.put("target", operationDTO.getAttach().getTarget());
        }
        rawData.put("category", executeContext.getCategory());
        rawData.put("tmActivityId", executeContext.getTmActivityId());
        rawData.put("tmActivityName", executeContext.getTmActivityName());
        jumpAction.setRawData(rawData);
        action.setBtnType("jump");
        action.setJumpAction(jumpAction);
        action.setTitle(operationDTO.getTitle());
        button.setSubmitAction(action);
        return button;
    }

    public static Boolean isExistImport(List<BaseMobileComponentWrapper<BaseMobileComponent>> operationButtons) {
        if (Objects.isNull(operationButtons)) {
            return false;
        }
        if (operationButtons.size() < 1) {
            return false;
        }
        BaseMobileComponentWrapper<BaseMobileComponent> wrapper = operationButtons.get(0);
        if (wrapper.getData() instanceof ButtonGroup) {
            ButtonGroup buttonGroup = (ButtonGroup) wrapper.getData();
            if (buttonGroup != null) {
                for (BaseMobileComponentWrapper<BottomButtonDigiwinAthena> button : buttonGroup.getContentGroup()) {
                    if (Objects.equals(ActionTypeEnum.OPEN_NEW_PAGE_FROM_IMPORT.getValue(), button.getData().getAction().getType())) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private BaseMobileComponentWrapper<BaseMobileComponent> buildContentTemplate(Card cardListData, ComponentContext cmptContext, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        EditCard editCard = JsonUtil.objectToJavaObject(cardListData, EditCard.class);
        editCard.handleComponentParam(cmptContext, null, null, new HashMap<>(), executeContext, mobilePageRawData);
        return new BaseMobileComponentWrapper<>(editCard, "DW_" + EditCard.COMPONENT_TYPE, editCard.getSchema(), editCard.getMobilePath());
    }

    public Boolean getIsCheckList(Card cardListData, Boolean isCheckList) {
        List<CardProcessedCondition> processedConditions = Optional
                .ofNullable(cardListData)
                .map(Card::getData)
                .map(Card.DesignerRawCard::getProcessedConditionList)
                .orElse(null);
        // wjw FIXME: 2024/5/26 底部按钮是否校验编辑卡片列表，先使用设计器中是否配置processedConditionList来控制
        return CollectionUtils.isEmpty(processedConditions) ? isCheckList : true;
    }

    /**
     * 卡片按钮滑动特效开启处理
     * 目前多个按钮只能支持开启一个按钮的滑动特效
     */
    private void handleCardButtonDetailPageSwiper() {
        List<UiBotAction> buttonList = Optional.ofNullable(this.cardListData).map(Card::getData)
                .map(Card.DesignerRawCard::getButtonList).orElse(new ArrayList<>());
        // 子标题按钮
//        Optional.ofNullable(this.cardListData).map(Card::getData).map(Card.DesignerRawCard::getSubTitleButton).ifPresent(buttonList::add);
        //判断卡片上的新增按钮是否有滑动特效(新：type=20，旧：detailPageSwiper=true)
        boolean isButtonDetailPageSwiperOpen = buttonList.stream().anyMatch(e -> {
            Boolean detailPageSwiper = Optional.ofNullable(e.getJumpAction()).map(UiBotJumpAction::getDetailPageSwiper).orElse(false);
            Boolean newDetailPageSwiper = Optional.ofNullable(e.getJumpAction())
                    .map(UiBotJumpAction::getType)
                    .map(type -> Objects.equals(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM_SWIPER.getValue(), type))
                    .orElse(false);
            return BooleanUtils.isTrue(detailPageSwiper) || BooleanUtils.isTrue(newDetailPageSwiper);
        });

        Card.DesignerRawCard.DetailPage detailPage = Optional.ofNullable(this.cardListData).map(Card::getData).map(Card.DesignerRawCard::getDetailPage).orElse(null);
        if (isButtonDetailPageSwiperOpen) {
            AtomicReference<String> pageId = new AtomicReference<>("");
            //统一按钮上的type统一处理，如果detailPageSwiper=true或type=20的情况下的情况，先预处理type=2222，后面会在button中再处理
            buttonList.forEach(e -> {
                UiBotJumpAction uiBotJumpAction = e.getJumpAction();
                if (ObjectUtils.isNotEmpty(uiBotJumpAction) && (BooleanUtils.isTrue(uiBotJumpAction.getDetailPageSwiper()) ||
                        Objects.equals(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM_SWIPER.getValue(), uiBotJumpAction.getType()))) {
                    uiBotJumpAction.setType(ActionTypeEnum.CUSTOMIZE_POPUP_DISPLAYS_PAGE.getValue());
                    e.setJumpAction(uiBotJumpAction);
                    pageId.set(uiBotJumpAction.getJumpPageId());
                }
            });
            if (Objects.isNull(detailPage)) {
                detailPage = new Card.DesignerRawCard.DetailPage();
            }
            if (Objects.nonNull(this.cardListData)) {
                this.detailPageSwiper = true;
                this.cardListData.setCardButtons(null);
                this.cardListData.getCardButtons();
                if (BooleanUtils.isTrue(detailPage.getDetailPageSwiper()) ||
                        ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM_SWIPER.getValue().equals(detailPage.getType())) {
                    //按钮和卡片上都有滑动特效，opentailType给0
                    this.cardListData.getData().setOpenDetailType(CardOpenDetailTypeEnum.BY_BUTTON_AND_CARD.getValue());
                } else {
                    //按钮有滑动特效，卡片没有滑动特效，opentailType给2
                    this.cardListData.getData().setOpenDetailType(CardOpenDetailTypeEnum.BY_BUTTON.getValue());
                    Card.DesignerRawCard.DetailPage cardAction = new Card.DesignerRawCard.DetailPage();
                    //卡片的跳转配置赋值给临时变量，用于构建普通跳转的cardAction
                    cardAction.setType(detailPage.getType());
                    cardAction.setDetailPageSwiper(false);
                    cardAction.setPageId(detailPage.getPageId());
                    this.cardListData.getData().setCardAction(cardAction);
                }
                // 统一构建detailPage，按钮和卡片上都有滑动特效的时候，则按钮的滑动特效会覆盖卡片的
                detailPage.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                detailPage.setDetailPageSwiper(true);
                detailPage.setPageId(pageId.get());
            }
        } else {
            if (Objects.isNull(detailPage)) {
                detailPage = new Card.DesignerRawCard.DetailPage();
            }
            if (Objects.nonNull(this.cardListData)) {
                if (BooleanUtils.isTrue(detailPage.getDetailPageSwiper()) ||
                        ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM_SWIPER.getValue().equals(detailPage.getType())) {
                    //按钮没有滑动特效，卡片有滑动特效，opentailType给1且卡片列表的detailPageSwiper为true
                    this.detailPageSwiper = true;
                    this.cardListData.getData().setOpenDetailType(CardOpenDetailTypeEnum.BY_CARD.getValue());
                } else {
                    //两者都没有滑动特效
                    this.detailPageSwiper = false;
                    this.cardListData.getData().setOpenDetailType(null);
                    Card.DesignerRawCard.DetailPage cardAction = new Card.DesignerRawCard.DetailPage();
                    //卡片的跳转配置赋值给临时变量，用于构建普通跳转的cardAction
                    cardAction.setType(detailPage.getType());
                    cardAction.setDetailPageSwiper(false);
                    cardAction.setPageId(detailPage.getPageId());
                    this.cardListData.getData().setCardAction(cardAction);
                }
            }
        }
    }

    private void convertCardListAdd(List<PcUiBotTmOperation> operations) {
        if (CollectionUtils.isEmpty(operations)) {
            return;
        }
        for (PcUiBotTmOperation operation : operations) {
            if ("card_list_add".equals(operation.getType())) {
                PcUiBotTmOperation.CardListAddObj cardListAddObj = JsonUtil.objectToJavaObject(operation.getSetting(), PcUiBotTmOperation.CardListAddObj.class);
                if (BooleanUtils.isTrue(cardListAddObj.getCanAddOrEditCard())) {
                    this.addCardType = cardListAddObj.getAddCardType();
                    this.canAddOrEditCard = cardListAddObj.getCanAddOrEditCard();
                    this.addCardButton = cardListAddObj.getAddCardButton();
                    this.canShowBottom = cardListAddObj.getCanShowBottom();
                }
            }
        }
        this.operations = null;
    }
}