package com.digiwin.mobile.mobileuibot.core.component.list.employeelist;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.ArrayList;
import java.util.List;

/**
 * 功能: 人员组件列表
 *
 * @author: wjw
 * @date: created at 2023/2/3
 */
@Data
@Accessors(chain = true)
public class EmployeeList extends BaseMobileComponent {
    private static final long serialVersionUID = -1306909430468181461L;
    public static final String COMPONENT_TYPE = "EMPLOYEE_LIST";

    /**
     * 标题
     */
    private String title;
    /**
     * 右边标题
     */
    private String rightTitle;

    private Integer total;

    private List<EmployeeData> employeeDatas = new ArrayList<>();
    /**
     * 样式
     */
    private Integer style = 1;

    @Override
    public String returnComponentType() {
        return EmployeeList.COMPONENT_TYPE;
    }
}
