package com.digiwin.mobile.mobileuibot.core.component.list.multi;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 多功能列表组件
 * 支持分页加载、搜索、单选、多选、不选、两种前端样式
 *
 * @author zhangjj
 * @date 2022/11/23 13:48
 */
@Data
public class MultiFunctionList extends BaseInputMobileComponent implements Serializable {
    private static final long serialVersionUID = 5664245814514214224L;
    public static final String COMPONENT_TYPE = "MULTI_FUNCTION_LIST";

    /**
     * 标题
     */
    private String title;
    /**
     * 样式类型
     * CARD：列表条目用卡片样式；
     * SPLIT_LINE：列表条目用分割线间隔
     */
    private String styleType;
    /**
     * 是否可分页加载
     */
    private Boolean pageable;
    /**
     * 是否支持搜索
     */
    private Boolean search;
    /**
     * 搜索类型默认为1  1：后端搜索；2：前端搜索；
     */
    private Integer searchType = 1;
    /**
     * 数据接口
     */
    private String dataUrl;
    /**
     * 选择类型
     * SINGLE_CHOICE：单选；
     * MULTIPLE_CHOICE：多选；
     * NO_CHOICE：不支持选择。
     * （当单选多选时为录入组件，当不可选择时为展示组件，前端默认不可选择）
     */
    private String choice;

    private ApiRawData rawData;

    /**
     * 提交id列表
     */
    private List<String> selectIdList;

    /**
     * 提交detail列表
     */
    private List<Map<String, Object>> selectDetailList;
    /**
     * 数据源
     */
    private List dataList;

    @Override

    public String returnComponentType() {
        return MultiFunctionList.COMPONENT_TYPE;
    }
}
