package com.digiwin.mobile.mobileuibot.core.component.list.multi;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：图片组件参数解析器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PictureParamAnalyzer
 * @Author: Zaregoto
 * @Date: 2021/7/27 18:36
 */
@Component("multiFunctionParamAnalyzer")
public class MultiFunctionParamAnalyzer implements ComponentParamAnalyzer<MultiFunctionList, Map> {

    private static final Logger logger = LoggerFactory.getLogger(MultiFunctionParamAnalyzer.class);

    @Autowired
    private LocaleService localeService;

    @Override
    public String getComponentType() {
        return MultiFunctionList.COMPONENT_TYPE;
    }

    @Override
    public Class<MultiFunctionList> getSubmitParamType() {
        return MultiFunctionList.class;
    }


    @Override
    public Map<String, Object> analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof MultiFunctionList)) {
            logger.debug("submitParam is not instanceof MultiFunctionList component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return Collections.emptyMap();
        }
        Map<String, Object> params = new HashMap<>(2);
        MultiFunctionList multiFunctionList = (MultiFunctionList) submitParam;
        params.put("selectIdList", multiFunctionList.getSelectIdList());
        params.put("selectDetailList", multiFunctionList.getSelectDetailList());
        return params;
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey,
                                   UiBotPageData pageData, Object... args) {
        MultiFunctionList multiFunctionList = JsonUtil.objectToJavaObject(pageData.get(pageDataKey), MultiFunctionList.class);
        multiFunctionList.setTitle(localeService.getLanguageValue(apiRequest.getLocale(), multiFunctionList.getTitle()));
        multiFunctionList.setRawData(apiRequest.getRawData());
        pageData.put(pageDataKey, multiFunctionList);
    }
}
