package com.digiwin.mobile.mobileuibot.core.component.list.numberlist;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 数字列表组件
 *
 * @author zhangjj
 * @date 2022/5/18 15:04
 */
@Data
public class NumberList extends BaseMobileComponent implements Serializable {
    private static final long serialVersionUID = 4885973461518505566L;
    public static final String COMPONENT_TYPE = "NUMBER_LIST";

    /**
     * 组件标题
     */
    private String title;

    /**
     * 更多页面的标题
     */
    private String morePageTitle;

    /**
     * 最多展示的条目数量(条目数量超过该值时，下方出现“查看更多”按钮)
     */
    private Integer displayDataNum;

    /**
     * 分类信息
     */
    private List<NumberListCategory> categoryList;

    /**
     * 是否展示categoryTitle行，仅当categoryList长度为1时有效
     */
    private Boolean showCategoryTitle;

    @Override
    public String returnComponentType() {
        return NumberList.COMPONENT_TYPE;
    }
}
