package com.digiwin.mobile.mobileuibot.core.component.list.numberlist;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 数字列表组件-分类信息
 *
 * @author zhangjj
 * @date 2022/5/18 15:07
 */
@Data
public class NumberListCategory implements Serializable {
    private static final long serialVersionUID = 2658791216741216889L;

    /**
     * 分类标题，在筛选分类名称前，切换分类名称后同步修改分类标题
     */
    private String categoryTitle;

    /**
     * 分类名称
     */
    private String categoryName;

    /**
     * 是否默认选中该分类
     */
    private Boolean defaultSelect;

    /**
     * 当前分类下条目数量
     */
    private Double number;

    /**
     * 当前分类下条目信息
     */
    private List<NumberListCategoryData> data;

    /**
     * 空提示文字（没有分类型条目信息时的提示文字）
     */
    private String emptyPromptText;
}
