package com.digiwin.mobile.mobileuibot.core.component.list.pageable;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

/**
 * 可分页加载列表组件
 *
 * @author Liux
 * @time 2022年9月15日 14点23分
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PageableList extends BaseMobileComponent implements Serializable {

    private static final long serialVersionUID = -3566995429807169229L;
    public static final String COMPONENT_TYPE = "PAGEABLE_LIST";

    @Override
    public String returnComponentType() {
        return PageableList.COMPONENT_TYPE;
    }

    /**
     * 业务数据
     */
    private Map<String, Object> rawData;
    /**
     * 列表数据接口地址
     */
    private String requestUrl;
    /**
     * 组件标题
     */
    private String title;

    public static PageableList create(Map<String, Object> rawData, String requestUrl, String title) {
        PageableList pageableList = new PageableList();
        pageableList.setRawData(rawData);
        pageableList.setRequestUrl(AppContext.getBaseUrl() + requestUrl);
        pageableList.setTitle(title);
        return pageableList;
    }
}