package com.digiwin.mobile.mobileuibot.core.component.list.pageable;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.list.numberlist.NumberListCategoryData;
import com.digiwin.mobile.mobileuibot.core.component.list.numberlist.NumberListCategoryDataField;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 可分页加载列表组件数据
 *
 * @author Liux
 * @time 2022年9月15日 14点23分
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PageableListData implements Serializable {

    private static final long serialVersionUID = -9018640201109676673L;

    /**
     * 列表数据
     */
    private List<BaseMobileComponentWrapper> dataList;
    /**
     * 是否还有下一页
     */
    private Boolean hasNext;
    /**
     * 总资料数
     */
    private Integer total;

    public static PageableListData create(Integer total, Boolean hasNext, List<Map<String, Object>> deliveryDetail) {
        PageableListData pageableListData = new PageableListData();
        pageableListData.setTotal(total);
        pageableListData.setHasNext(hasNext);
        List<BaseMobileComponentWrapper> dataList = new ArrayList<>();
        for (Map<String, Object> dataMap : deliveryDetail) {
            NumberListCategoryData data = new NumberListCategoryData();
            data.setTitle(String.valueOf(dataMap.get("item_name")));
            List<NumberListCategoryDataField> fields = new ArrayList<>();
            NumberListCategoryDataField numberListCategoryDataField = new NumberListCategoryDataField();
            if (dataMap.containsKey("item_spec")) {
                numberListCategoryDataField = NumberListCategoryDataField.create("规格",
                        String.valueOf(dataMap.get("item_spec")));
                fields.add(numberListCategoryDataField);
            }
            if (dataMap.containsKey("delivery_qty")) {
                Double deliveryQtyDouble = Double.parseDouble(dataMap.get("delivery_qty").toString());
                int deliveryQtyInt = deliveryQtyDouble == null ? 0 : deliveryQtyDouble.intValue();
                numberListCategoryDataField = NumberListCategoryDataField.create("应发数量",
                        deliveryQtyInt + " " + String.valueOf(dataMap.get("unit_name")));
                fields.add(numberListCategoryDataField);
            }
            data.setFields(fields);

            BaseMobileComponentWrapper baseMobileComponentWrapper = new BaseMobileComponentWrapper<>(data, NumberListCategoryData.COMPONENT_TYPE + "_ITEM");
            dataList.add(baseMobileComponentWrapper);
        }
        pageableListData.setDataList(dataList);
        return pageableListData;

    }

}