package com.digiwin.mobile.mobileuibot.core.component.list.personnel;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.LayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelStateEnum;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Data
@Accessors(chain = true)
public class PersonnelGroupGroup implements Serializable {
    private static final long serialVersionUID = -5506055554925817130L;

    /**
     * 组别
     */
    private String title = "";
    /**
     * 总数
     */
    private Integer total = 0;
    /**
     * 0：水平布局，1：垂直布局
     */
    private Integer layoutType = LayoutTypeEnum.HORIZONTAL.getValue();

    private List<PersonnelGroupGroupData> dataList = new ArrayList<>();

    public PersonnelGroupGroup convert(ApiRequest apiRequest, List<WoOpReportInfo> teamList, Map<String, Object> rawData) {
        if (CollectionUtils.isEmpty(teamList)) {
            return this;
        }
        this.title = teamList.get(0).getTeamName();
        this.total = teamList.size();
        this.layoutType = LayoutTypeEnum.HORIZONTAL.getValue();

        Map<PersonnelStateEnum, List<WoOpReportInfo>> map =
                teamList.stream().collect(Collectors.groupingBy(WoOpReportInfo::getStateEnum));
        this.dataList = new ArrayList<>();
        dataList.add(new PersonnelGroupGroupData()
                .convert(apiRequest, PersonnelStateEnum.ONLINE, map.get(PersonnelStateEnum.ONLINE))
                .createAction(PersonnelStateEnum.ONLINE, teamList, rawData));
        dataList.add(new PersonnelGroupGroupData()
                .convert(apiRequest, PersonnelStateEnum.OFFLINE, map.get(PersonnelStateEnum.OFFLINE))
                .createAction(PersonnelStateEnum.OFFLINE, teamList, rawData));
        dataList.add(new PersonnelGroupGroupData()
                .convert(apiRequest, PersonnelStateEnum.EXCEPT, map.get(PersonnelStateEnum.EXCEPT))
                .createAction(PersonnelStateEnum.EXCEPT, teamList, rawData));
        dataList.add(new PersonnelGroupGroupData()
                .convert(apiRequest, PersonnelStateEnum.SUPPORT, map.get(PersonnelStateEnum.SUPPORT))
                .createAction(PersonnelStateEnum.SUPPORT, teamList, rawData));
        return this;
    }
}
