package com.digiwin.mobile.mobileuibot.core.component.list.personnel;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelStateEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.StateTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
@Accessors(chain = true)
public class PersonnelGroupGroupData implements Serializable {
    private static final long serialVersionUID = -2684837375589342098L;
    /**
     * label -已上线/未上线/除外
     */
    private String label;
    /**
     * 数量
     */
    private String value = "0";
    /**
     * 点击按钮触发
     */
    private Action action;
    /**
     * 0：一般，灰色；1：正常，蓝色；2：异常，红色
     */
    private Integer type;

    public PersonnelGroupGroupData convert(ApiRequest apiRequest, PersonnelStateEnum stateEnum,
                                           List<WoOpReportInfo> teamStateList) {
        if (CollectionUtils.isEmpty(teamStateList)) {
            this.value = "0";
        } else {
            this.value = String.valueOf(teamStateList.size());
        }
        this.label = LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), stateEnum.getDesc());
        switch (stateEnum) {
            case ONLINE:
                this.type = StateTypeEnum.NORMAL.getValue();
                break;
            case OFFLINE:
                this.type = StateTypeEnum.ABNORMAL.getValue();
                break;
            case EXCEPT:
                this.type = StateTypeEnum.GENERAL.getValue();
                break;
            default:
                break;
        }
        return this;
    }

    public PersonnelGroupGroupData createAction(PersonnelStateEnum stateEnum, List<WoOpReportInfo> teamList, Map<String, Object> rawData) {
        Action<Map<String, Object>> action = new Action<>();
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_DIRECTOR_CHECK_PERSONNEL_ONLINE_GROUP_DETAIL.toString());
        action.setJumpPageTitle(teamList.get(0).getTeamName());
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        Map<String, Object> map = new HashMap<>();
        map.put("teamNo", teamList.get(0).getTeamNo());
        map.put("stateType", stateEnum.name());
        map.putAll(rawData);
        action.setRawData(map);

        this.action = action;
        return this;
    }
}
