package com.digiwin.mobile.mobileuibot.core.component.list.personnel;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.LayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelStateEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

/**
 * 功能: 人员状态 列表组件
 *
 * @author: wjw
 * @date: created at 2023/2/3
 */
@Data
@Accessors(chain = true)
public class PersonnelState extends BaseMobileComponent {
    private static final long serialVersionUID = -7728343580346569650L;
    public static final String COMPONENT_TYPE = "PERSONNEL_STATE";
    /**
     * 组件标题
     */
    private String title = "";
    /**
     * 0：水平布局，1：垂直布局
     */
    private Integer layoutType = LayoutTypeEnum.VERTICAL.getValue();
    private List<PersonnelStateGroup> stateList = new ArrayList<>();

    @Override
    public String returnComponentType() {
        return PersonnelState.COMPONENT_TYPE;
    }


    public PersonnelState convert(ApiRequest apiRequest, LocaleService localeService,
                                  PersonnelStateEnum stateEnum, List<WoOpReportInfo> reportList) {
        if (CollectionUtils.isEmpty(reportList)) {
            return this;
        }
        this.layoutType = LayoutTypeEnum.VERTICAL.getValue();

        //人员状况依据班组名称排序,简体按拼音，繁体按笔画来升序
        this.stateList = reportList.stream().collect(Collectors.groupingBy(WoOpReportInfo::getTeamNo))
                .values().stream().sorted((o1, o2) -> {
                            java.text.Collator collator;
                            if ("zh_CN".equalsIgnoreCase(apiRequest.getLocale())) {
                                collator = java.text.Collator.getInstance(Locale.SIMPLIFIED_CHINESE);
                            } else {
                                collator = java.text.Collator.getInstance(Locale.TRADITIONAL_CHINESE);
                            }
                            return collator.compare(o1.get(0).getTeamName(), o2.get(0).getTeamName());
                        }
                )
                .map(teamList -> new PersonnelStateGroup().convert(apiRequest, localeService, stateEnum, teamList))
                .collect(Collectors.toList());
        return this;
    }
}
