package com.digiwin.mobile.mobileuibot.core.component.list.personnel;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.LayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelStateEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

@Data
@Accessors(chain = true)
public class PersonnelStateGroup extends BaseMobileComponent {
    private static final long serialVersionUID = -5506055554925817130L;
    public static final String COMPONENT_TYPE = "PERSONNEL_STATE_GROUP";

    @Override
    public String returnComponentType() {
        return PersonnelStateGroup.COMPONENT_TYPE;
    }

    /**
     * 组别
     */
    private String title = "";
    /**
     * 总数
     */
    private Integer total = 0;
    /**
     * 0：水平布局，1：垂直布局
     */
    private Integer layoutType = LayoutTypeEnum.VERTICAL.getValue();
    /**
     * 是否使用展开收起功能
     */
    private Boolean isExpand = false;

    private List<PersonnelStateGroupData> dataList = new ArrayList<>();

    public PersonnelStateGroup convert(ApiRequest apiRequest, LocaleService localeService,
                                       PersonnelStateEnum stateEnum, List<WoOpReportInfo> teamList) {
        if (CollectionUtils.isEmpty(teamList)) {
            return this;
        }
        this.title = teamList.get(0).getTeamName();
        this.isExpand = true;
        this.total = teamList.size();
        switch (stateEnum) {
            case ONLINE:
                this.layoutType = LayoutTypeEnum.VERTICAL.getValue();

                //班组展开里面内容排序 依据1.製令單號、2.生產批號、3.製程編號、4.人員名稱排序
                teamList = sortTeamList(teamList, apiRequest);
                break;
            case OFFLINE:
                this.layoutType = LayoutTypeEnum.HORIZONTAL.getValue();
                break;
            case EXCEPT:
                this.layoutType = LayoutTypeEnum.VERTICAL.getValue();
                break;
            default:
                break;
        }
        this.dataList = teamList.stream()
                .map(item -> new PersonnelStateGroupData().convert(apiRequest, localeService, stateEnum, item))
                .collect(Collectors.toList());
        return this;
    }

    /**
     * 1.製令單號、2.生產批號、3.製程編號===>依据首字母升序+数字升序排列
     * 4.人員名稱就按語系決定要用筆劃還是拼音
     */
    public static List<WoOpReportInfo> sortTeamList(List<WoOpReportInfo> teamList, ApiRequest apiRequest){
        return teamList.stream().sorted((o1, o2) -> {
                    java.text.Collator collator;
                    if ("zh_CN".equalsIgnoreCase(apiRequest.getLocale())) {
                        collator = java.text.Collator.getInstance(Locale.SIMPLIFIED_CHINESE);
                    } else {
                        collator = java.text.Collator.getInstance(Locale.TRADITIONAL_CHINESE);
                    }

                    if (!StringUtils.equals(o1.getWoNo(), o2.getWoNo())) {
                        return compareVal(o1.getWoNo(), o2.getWoNo(), collator);
                    }

                    if (!StringUtils.equals(o1.getPlotNo(), o2.getPlotNo())) {
                        return compareVal(o1.getPlotNo(), o2.getPlotNo(), collator);
                    }

                    if (!StringUtils.equals(o1.getOpNo(), o2.getOpNo())) {
                        return compareVal(o1.getOpNo(), o2.getOpNo(), collator);
                    }
                    return collator.compare(o1.getReporterName(), o2.getReporterName());
                }
        ).collect(Collectors.toList());
    }

    /**
     * 为空字段往后放，不为空进行比较
     */
    private static int compareVal(String val1, String val2, Collator collator) {
        if (StringUtils.isEmpty(val1) && StringUtils.isNotEmpty(val2)) {
            return 1;
        }
        if (StringUtils.isEmpty(val2) && StringUtils.isNotEmpty(val1)) {
            return -1;
        }
        return collator.compare(val1, val2);
    }
}
