package com.digiwin.mobile.mobileuibot.core.component.list.personnel;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelStateEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Data
@Accessors(chain = true)
public class PersonnelStateGroupData extends BaseMobileComponent {
    private static final long serialVersionUID = -2684837375589342098L;
    public static final String COMPONENT_TYPE = "PERSONNEL_STATE_DATA";
    /**
     * 标题，人员名称
     */
    private String title;
    /**
     * 已上线/未上线/除外
     */
    private String stateText = "";
    /**
     * 修饰 stateText 样式
     * 0：一般，灰色；1：正常，蓝色；2：异常，红色
     */
    private Integer type;
    /**
     * 展示类型
     * 1: 上下：上面图片下面名称  2：左右：左边图片右边名称
     */
    private Integer displayType;
    /**
     * 其它信息
     */
    private List<Field> content;
    /**
     * eoc中间件中的员工编号
     */
    private String eocId;

    @Override
    public String returnComponentType() {
        return PersonnelStateGroupData.COMPONENT_TYPE;
    }

    public PersonnelStateGroupData convert(ApiRequest apiRequest, LocaleService localeService,
                                           PersonnelStateEnum stateEnum, WoOpReportInfo item) {
        if (item == null) {
            return this;
        }
        this.title = item.getReporterName();
        this.eocId = item.getReporterNo();
        switch (stateEnum) {
            case ONLINE:
                this.displayType = 2;
                List<Field> online = new ArrayList<>();
                online.add(Field.createLabelValueLeftField(localeService.
                                getLanguageValue(apiRequest.getLocale(), "所在工艺"),
                        item.getOpName()));
                online.add(Field.createLabelValueLeftField(localeService.
                                getLanguageValue(apiRequest.getLocale(), "工单单号"),
                        item.getWoNo()));
                online.add(Field.createLabelValueLeftField(localeService.
                                getLanguageValue(apiRequest.getLocale(), "生产批号"),
                        item.getPlotNo()));
                online.add(Field.createLabelValueLeftField(localeService.
                                getLanguageValue(apiRequest.getLocale(), "计划批号"),
                        item.getPlanLotNo()));

                // 中文显示项目代号，项目名称, 繁体显示繁体的 专案代号，专案名称
                String projectNoLabel = "zh_TW".equalsIgnoreCase(apiRequest.getLocale()) ? "专案代号" : "项目代号";
                online.add(Field.createLabelValueLeftField(localeService.
                                getLanguageValue(apiRequest.getLocale(), projectNoLabel),
                        item.getProjectNo()));

                String projectNameLabel = "zh_TW".equalsIgnoreCase(apiRequest.getLocale()) ? "专案名称" : "项目名称";
                online.add(Field.createLabelValueLeftField(localeService.
                                getLanguageValue(apiRequest.getLocale(), projectNameLabel),
                        item.getProjectName()));
                online.add(Field.createLabelValueLeftField(localeService.
                                getLanguageValue(apiRequest.getLocale(), "区域"),
                        item.getAreaName()));
                // 若备注有值，则显示该字段，若备注空值，则该字段不显示
                if (StringUtils.isNotEmpty(item.getRemark())) {
                    online.add(Field.createLabelValueLeftField(localeService.
                                    getLanguageValue(apiRequest.getLocale(), "备注"),
                            item.getRemark()));
                }
                this.content = online;
                break;
            case OFFLINE:
                this.displayType = 1;
                break;
            case EXCEPT:
                this.displayType = 2;
                List<Field> except = new ArrayList<>();
                except.add(Field.createLabelValueLeftField(localeService.
                                getLanguageValue(apiRequest.getLocale(), "除外原因"),
                        item.getExceptName()));
                except.add(Field.createLabelValueLeftField(localeService.
                                getLanguageValue(apiRequest.getLocale(), "时间"),
                        this.exceptTime(item.getStartTime(), item.getEndTime())));

                // 若备注有值，则显示该字段，若备注空值，则该字段不显示
                if (StringUtils.isNotEmpty(item.getRemark())) {
                    except.add(Field.createLabelValueLeftField(localeService.
                                    getLanguageValue(apiRequest.getLocale(), "备注"),
                            item.getRemark()));
                }
                this.content = except;
                break;
            default:
                break;
        }
        return this;
    }

    private String exceptTime(Date startTime, Date endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(startTime).split(" ")[1].substring(0, 5) +
                "-" +
                sdf.format(endTime).split(" ")[1].substring(0, 5);
    }
}
