package com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist;

import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @Description ZtbUnloadingItemList
 * @Author maoheng
 * @Data 2023/4/24
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ZtbUnloadingItemList implements Serializable {

    private static final long serialVersionUID = 5267214764586548999L;


    private String styleType = "SPLIT_LINE";
    private boolean pageable;
    private boolean search;
    private List<DataList> dataList;
    private int searchType;
    private String dataUrl;
    private String choice;
    private Map<String, Object> rawData;
    private Action action;

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class DataList {
        private String cmptUuid;
        private String title;
        private String dataId;
        private Detail detail;
        private List<Content> content;
        private List<?> buttonList;
        private Object adderSubstracter;
        private Boolean canEdit;
        private Map<String, Object> rawData;

        @Data
        @NoArgsConstructor
        @AllArgsConstructor
        public static class Detail {
            private String item_no;
            private String item_name;
            private String item_spec;
            private String item_qty;
            private String un_loading_qty;
            private String unit_no;
            private String unit_name;
        }

        @Data
        @NoArgsConstructor
        @AllArgsConstructor
        public static class Content {
            private String label;
            private String value;
            private int valueStyleType;
            private String schema;
        }
    }
}
