package com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist;

import cn.hutool.core.date.DateUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ComponentDslDataRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.CommonRawDataParentType;
import com.digiwin.mobile.mobileuibot.core.common.PcmFilterUtil;
import com.digiwin.mobile.mobileuibot.core.component.*;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.HiddenConfig;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardOpenDetailTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardProcessedCondition;
import com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.AddCardTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.CardListTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListChoiceEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.personnel.PersonnelStateGroup;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.model.db1.UserCardListFilter;
import com.digiwin.mobile.mobileuibot.mysql.model.UserCardListFilterQueryDTO;
import com.digiwin.mobile.mobileuibot.mysql.service.UserCardListFilterService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmRequest;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.model.BaseDataStatusConfig;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPatternUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotTagConstant;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

import static com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.EditCardList.buildOperationButtons;
import static com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.EditCardList.isExistImport;
import static com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils.localeService;

/**
 * 在途宝展示列表（定制）
 *
 * @author wuyangz
 * @date 20230321
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ZtbViewList extends BaseMobileComponent {
    public static final String COMPONENT_TYPE = "ZTB_VIEW_LIST";
    private static final long serialVersionUID = -4164810408038812593L;

    private String title;
    /**
     * 标题是否显示，true：显示，false：隐藏
     */
    private Boolean titleVisible = false;
    private Integer titleStyle;
    private List<Card> data;
    private HiddenConfig hiddenConfig;
    private String schema;
    private Boolean showMore;
    //是否可滑动查看其他卡片详情，默认false
    private Boolean detailPageSwiper = false;
    /**
     * 当前卡片列表是否校验 true：校验，false：不校验
     * 用于底部按钮是否校验卡片，使其高亮可点击
     */
    private Boolean isCheckList = false;

    /**
     * 是否提交
     */
    private Boolean isNeedSubmit;
    /**
     * 排序类型
     * 0:不排序 1：显示普通序号 2：前三张卡高亮（排名）
     */
    private Integer seqType;

    /**
     * 操作按钮集合
     */
    private List<PcUiBotTmOperation> operations;

    /**
     * 返回给前端的
     */
    @JsonDeserialize(contentUsing = BaseMobileComponentWrapperJsonDeserializer.class)
    private List<BaseMobileComponentWrapper<BaseMobileComponent>> operationButtons;


    private Boolean hasOperationImport = false;

    public static ZtbViewList create(ZtbViewList ztbViewList, Map<String, Object> cargoInformation,
                                     LocaleService localeService, String locale) {
        ztbViewList.setTitle(localeService.getLanguageValue(locale, ztbViewList.getTitle()));
        HiddenConfig hiddenConfig = ztbViewList.getHiddenConfig();
        hiddenConfig.setHiddenExpandContent(localeService.getLanguageValue(locale,
                hiddenConfig.getHiddenExpandContent()));
        hiddenConfig.setHiddenUnexpandContent(localeService.getLanguageValue(locale,
                hiddenConfig.getHiddenUnexpandContent()));
        List<Map<String, Object>> dataList = (List<Map<String, Object>>) cargoInformation.get("cargo_information");
        List<Card> data = new ArrayList<>(dataList.size());
        dataList.forEach(dataMap -> {
            Card card = new Card();
            card.setTitle(dataMap.get("item_no") + "-" + dataMap.get("item_name"));
            card.setDataId((String) dataMap.get("item_no"));
            card.setDetail(dataMap);
            List<CardContent> content = card.getContent();
            CardContent cardContent = new CardContent();
            cardContent.setLabel(localeService.getLanguageValue(locale, "装车数量"));
            Double deliveryQtyDouble = 0.0;
            if (dataMap.get("transport_qty") != null) {
                deliveryQtyDouble = Double.parseDouble(dataMap.get("transport_qty").toString());
            }
            cardContent.setValue(deliveryQtyDouble.toString() + dataMap.get("unit_no"));
            cardContent.setValueStyleType(1);
            content.add(cardContent);
            data.add(card);
        });
        ztbViewList.setData(data);
        return ztbViewList;
    }

    public static ZtbViewList create(ZtbViewList ztbViewList, List<Map<String, Object>> dataList,
                                     LocaleService localeService, String locale) {
        ztbViewList.setTitle(localeService.getLanguageValue(locale, ztbViewList.getTitle()));
        HiddenConfig hiddenConfig = new HiddenConfig();
        hiddenConfig.setHiddenExpandContent(localeService.getLanguageValue(locale,
                "查看更多>"));
        hiddenConfig.setHiddenUnexpandContent(localeService.getLanguageValue(locale,
                ""));
        hiddenConfig.setHiddenCount(3);
        hiddenConfig.setHiddenType(2);
        ztbViewList.setHiddenConfig(hiddenConfig);
        List<Card> data = new ArrayList<>(dataList.size());
        dataList.forEach(dataMap -> {
            Card card = new Card();
            card.setTitle(dataMap.get("item_no") + "-" + dataMap.get("item_name"));
            card.setDataId((String) dataMap.get("item_no"));
            card.setDetail(dataMap);
            List<CardContent> content = card.getContent();
            CardContent cardContent = new CardContent();
            cardContent.setLabel(localeService.getLanguageValue(locale, "装车数量"));
            Double deliveryQtyDouble = 0.0;
            if (dataMap.get("transport_qty") != null) {
                deliveryQtyDouble = Double.parseDouble(dataMap.get("transport_qty").toString());
            }
            cardContent.setValue(deliveryQtyDouble.toString() + (StringUtils.hasLength(
                    (String) dataMap.get("item_unit")) ? dataMap.get("item_unit") : ""));
            cardContent.setValueStyleType(1);
            content.add(cardContent);
            data.add(card);
        });
        ztbViewList.setData(data);
        return ztbViewList;
    }

    public static ZtbViewList buildZtbViewList(ApiRequest apiRequest, LocaleService localeService, List<WoOpReportInfo> woOpReportInfoList) {
        String locale = apiRequest.getLocale();
        Map<String, List<WoOpReportInfo>> woOpReportInfoMapByMergeNo = woOpReportInfoList.stream()
                .collect(Collectors.groupingBy(WoOpReportInfo::getMergeNo));

        List<Card> cardList = new ArrayList<>();
        for (Map.Entry<String, List<WoOpReportInfo>> woOpReportInfoMapByMergeNoItem : woOpReportInfoMapByMergeNo.entrySet()) {
            String mergeNo = woOpReportInfoMapByMergeNoItem.getKey();
            List<WoOpReportInfo> woOpReportInfoListByMergeNo = woOpReportInfoMapByMergeNoItem.getValue();
            woOpReportInfoListByMergeNo = PersonnelStateGroup.sortTeamList(woOpReportInfoListByMergeNo, apiRequest);

            String opNameLabel = "zh_TW".equalsIgnoreCase(locale) ? "所在製程" : "所在工艺";
            // 是合并单号，有的话为合并工时，否则为工时支援/工时回报
            if (StringUtils.hasLength(mergeNo)) {
                // 同一个合并单号的数据需要根据人员名称再分组
                Map<String, List<WoOpReportInfo>> woOpReportInfoMapByReportName = woOpReportInfoListByMergeNo.stream().collect(Collectors.groupingBy(WoOpReportInfo::getReporterName));
                for (Map.Entry<String, List<WoOpReportInfo>> woOpReportInfoMapByReportNameItem : woOpReportInfoMapByReportName.entrySet()) {
                    Map<String, Object> cardContentMap = new LinkedHashMap<>();
                    List<WoOpReportInfo> woOpReportInfoListByReportName = woOpReportInfoMapByReportNameItem.getValue();
                    cardContentMap.put(opNameLabel, woOpReportInfoListByReportName.get(0).getOpName());
                    cardContentMap.put(localeService.getLanguageValue(locale, "合并单号"), mergeNo);
                    List<Button> buttonList = Button.buildButtonList(woOpReportInfoListByReportName, locale, localeService, true);
                    cardList.add(Card.create(woOpReportInfoListByReportName.get(0).getReporterName(), cardContentMap, buttonList, false));
                }
            } else {
                // 中文显示项目代号，项目名称, 繁体显示繁体的，专案名称
                String projectNoLabel = "zh_TW".equalsIgnoreCase(locale) ? "專案代號" : "项目代号";
                String projectNameLabel = "zh_TW".equalsIgnoreCase(apiRequest.getLocale()) ? "專案名稱" : "项目名称";
                String woNoLabel = "zh_TW".equalsIgnoreCase(apiRequest.getLocale()) ? "製令單號" : "工单单号";
                for (WoOpReportInfo woOpReportInfo : woOpReportInfoListByMergeNo) {
                    Map<String, Object> cardContentMap = new LinkedHashMap<>();
                    cardContentMap.put(opNameLabel, woOpReportInfo.getOpName());
                    cardContentMap.put(woNoLabel, woOpReportInfo.getWoNo());
                    cardContentMap.put(localeService.getLanguageValue(locale, "品名"), woOpReportInfo.getItemName());
                    cardContentMap.put(localeService.getLanguageValue(locale, "规格"), woOpReportInfo.getItemSpec());
                    cardContentMap.put(projectNoLabel, woOpReportInfo.getProjectNo());
                    cardContentMap.put(projectNameLabel, woOpReportInfo.getProjectName());
                    cardContentMap.put(localeService.getLanguageValue(locale, "区域"), woOpReportInfo.getAreaName());
                    cardContentMap.put(localeService.getLanguageValue(locale, "备注"), woOpReportInfo.getRemark());

                    List<Button> buttonList = Button.buildButtonList(Collections.singletonList(woOpReportInfo), locale, localeService, false);
                    cardList.add(Card.create(woOpReportInfo.getReporterName(), cardContentMap, buttonList, false));
                }
            }
        }
        ZtbViewList ztbViewList = new ZtbViewList();
        ztbViewList.setData(cardList);
        return ztbViewList;
    }

    public static ZtbViewList buildWoOpReportInfoSupportZtbViewList(ApiRequest apiRequest, LocaleService localeService,
                                                                    List<WoOpReportInfo> woOpReportInfoList, String bgColor) {
        String locale = apiRequest.getLocale();
        List<Card> cardList = woOpReportInfoList.stream().map(woOpReportInfo -> {
            List<CardContent> contentList = new LinkedList<>();
            contentList.add(CardContent.create(localeService.getLanguageValue(locale, "班组"), woOpReportInfo.getTeamName(), 1));
            contentList.add(CardContent.create(localeService.getLanguageValue(locale, "支援时数"), woOpReportInfo.getTotalLaborHours(), 1));
            contentList.add(CardContent.create(localeService.getLanguageValue(locale, "最后上线时间"), woOpReportInfo.getLatestCheckInDatetime(), 1));

            String dateRange = (Objects.nonNull(woOpReportInfo.getSupportDateStart()) ? woOpReportInfo.getSupportDateStart() : "")
                    + " ~ " + (Objects.nonNull(woOpReportInfo.getSupportDateEnd()) ? woOpReportInfo.getSupportDateEnd() : "");
            contentList.add(CardContent.create(localeService.getLanguageValue(locale, "请求区间"), dateRange, 1));

            List<Tag> tagList = BooleanUtils.isTrue(woOpReportInfo.getSupporterComplete()) ?
                    Collections.singletonList(Tag.createMediumRiskTag("停止支援")) : Collections.emptyList();
            Card card = Card.create(woOpReportInfo.getSupporterName(), contentList, tagList, null);
            if (StringUtils.hasLength(bgColor)) {
                card.setBgColor(bgColor);
            }
            if (!CollectionUtils.isEmpty(card.getCardButtons())) {
                card.getCardButtons().clear();
            }
            return card;
        }).collect(Collectors.toList());
        ZtbViewList ztbViewList = new ZtbViewList();
        ztbViewList.setData(cardList);
        return ztbViewList;
    }


    @Override
    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    /**
     * 设计态设计的card 结构
     */
    private Card cardListData;

    /**
     * 设计器：新增card按钮开关
     */
    private Boolean canAddOrEditCard;

    /**
     * 设计器：新增card按钮：设计态设计的结构
     */
    private UiBotAction addCardButton;

    /**
     * 前端使用 V2版DSL，新增按钮Action
     */
    private Action addItemAction;

    /**
     * 底部是否展示新增数据按钮，true为展示，false为隐藏，默认为false
     */
    private Boolean canShowBottom = false;

    /**
     * 前端使用：新增card所有数据
     */
    private List<ActionSubmitParam> cardAllDataList;

    /**
     * 是否整批提交场景  true：是，false：否
     * 前端根据此字段判断cardList组件是否是整批提交，true：条目详情页底部按钮暂存/保存并提交按钮控制
     * 只使用于line场景
     */
    private Boolean isAllSubmitScene = false;

    /**
     * 前端使用 V2版DSL，转表格按钮Action，null表示未开启
     */
    private Action tableAction;

    /**
     * 设计器：是否支持筛选
     */
    private Boolean canFilterCard = false;
    /**
     * 设计器：筛选按钮
     */
    private UiBotAction filterCardButton;
    /**
     * 运行态：V2版DSL，新增按钮Action
     */
    private Action filterAction;
    // 是否是筛选后的数据/是否首次默认弹出筛选框(filterFlag=false)
    private Boolean filterFlag;
    // 当前列表过滤条件
    private Map<String, Object> filterCondition;
    /**
     * 设计器 是否首次展示筛选
     */
    private Boolean showInitFilter = false;

    /**
     * @see com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListChoiceEnum
     */
    private String choice = MultiFunctionListChoiceEnum.NO_CHOICE.name();

    /**
     * 设计器新增属性，唯一标识cardList
     */
    private String componentId;

    /**
     * 设计器新增属性，card底部按钮布局类型
     * 1:折叠 2:平铺
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.button.ButtonLayoutTypeEnum
     */
    private Integer buttonLayoutType = ButtonLayoutTypeEnum.FOLD.getValue();

    /**
     * 设计器新增属性--卡片类型，默认1
     * 1：只读的卡片列表 DW_ZTB_VIEW_LIST (默认) ,  2：可编辑的卡片列表  DW_EDIT_CARD_LIST
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.CardListTypeEnum
     */
    private Integer cardListType = CardListTypeEnum.READ_CARD_LIST.getValue();
    /**
     * 设计器新增属性--添加card方式类型--默认1
     * 1：开弹窗或页面新增数据（默认），2：使用模板在当前页面新增数据
     * 注意：新增卡片场景下有效，并只在编辑的卡片列表中有效
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.AddCardTypeEnum
     */
    private Integer addCardType = AddCardTypeEnum.OPEN_PAGE_ADD.getValue();

    /**
     * 公共参数（需要把该参数里面的数据塞到对应的rawData里面）
     * 1、存储卡片列表下卡片的detailPage中RawData公共部分
     * 2、存储卡片列表下卡片的跳转类按钮中RawData公共部分
     */
    private Map<String, Object> commonChildRawData;

    /**
     * 设计器搜索--是否支持搜索
     */
    private Boolean canSearch = false;

    /**
     * 设计器搜索-设计态
     */
    private RawSearchConfig rawSearchConfig;

    /**
     * 设计器搜索-运行态
     */
    private SearchConfig searchConfig;

    @Data
    public static class RawSearchConfig {
        /**
         * 设计器设计态搜索--搜索提示
         */
        private String placeholder;
        /**
         * 设计器设计态搜索--是否开启分页
         */
        private Boolean useHasNext = false;
        // 是否显示搜索框，默认显示
        private Boolean showSearch = true;
        /**
         * 设计器设计态搜索--搜索字段信息
         */
        private List<Card.DesignerRawCard.Content> searchInfo;
    }

    @Data
    public static class SearchConfig {
        /**
         * 设计器运行态搜索--搜索提示
         */
        private String placeholder;

        /**
         * 设计器运行态搜索--是否开启分页
         */
        private Boolean useHasNext = false;
        // 是否显示搜索框，默认显示
        private Boolean showSearch = true;

        /**
         * 设计器运行态搜索--搜索的api接口
         */
        private String url;

        /**
         * 设计器运行态搜索--搜索字段信息
         */
        private List<PcUiBotActionSearchInfoMapping> searchInfo;

        private Map<String, Object> rawData;
    }

    /**
     * 设计器查询配置
     */
    private PcUiBotQueryInfo queryInfo;
    /**
     * 运行态分页配置
     */
    private PagingConfig pagingConfig;

    @Data
    public static class PagingConfig {
        // 分页接口
        private String url;
        // 分页参数
        private PcUiBotPageInfo pageInfo;
        // 分页rawdata
        private Map<String, Object> rawData;
    }

    @Override
    public void applyEditable(Boolean enable) {
        if (BooleanUtils.isFalse(enable)) {
            this.canAddOrEditCard = enable;
        }
    }

    public Action getAddItemAction(ComponentContext cmptContext, String mobilePath, String schema, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        if (BooleanUtils.isTrue(canAddOrEditCard)) {
            Button<UiBotAction> button = new Button<>();
            button.setSubmitAction(this.addCardButton);
            // 新增按钮暂不优化
            cmptContext.setCommonRawDataParentType(null);
            // 按钮组件
            button.handleComponentParam(cmptContext, mobilePath, schema, new HashMap<>(), executeContext, mobilePageRawData);
            cmptContext.setCommonRawDataParentType(CommonRawDataParentType.ALONE_LIST.getValue());
            // 卡片列表新增按钮清空dataId数据，处理三级页面本地保存时存在的问题
            button.getAction().setDataId("");
            this.addItemAction = button.getAction();
        }

        return addItemAction;
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                                     PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.resetCmptMultipleDataSourceDataAndQueryInfo(cmptContext, executeContext, Optional.ofNullable(this.cardListData).map(Card::getData).map(Card.DesignerRawCard::getDataSource).orElse(null), data, this.queryInfo);
        cmptContext.setCommonRawDataParentType(CommonRawDataParentType.ALONE_LIST.getValue());
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.handleCardList(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.commonChildRawData = buildCommonChildRawData(executeContext, mobilePageRawData);
        cmptContext.setCommonRawDataParentType(null);
    }

    private void handleCardList(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                                PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        // 设计器配置标题隐藏时，设置title为空字符串，flutter端根据标题为空默认隐藏
        this.title = BooleanUtils.isTrue(this.titleVisible) ? this.title : "";
        mobilePath = mobilePath == null ? "" : mobilePath.replaceAll("&", "");
        schema = schema == null ? "" : schema.replaceAll("&", "");
        handleRawCardListData(this.cardListData, executeContext, mobilePageRawData);
        List<Map<String, Object>> dataList;
        if (data.containsKey(UiBotDesignerRenderService.LIST_MARKER)) {
            // 任务详情页渲染
            if (isChildNode(mobilePath, schema)) {
                data.remove(UiBotDesignerRenderService.LIST_MARKER);
                // 详情页，列表是数据源下的一个节点
                mobilePageRawData.setRawMap(data);
                dataList = (List<Map<String, Object>>) UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
            } else {
                // 表示整体数据是数组 -- 不可传入rawMap数据，否则会影响非任务详情页提交按钮中action的rawdata中data数据
                mobilePageRawData.setRawMap(null);
                if (BooleanUtils.isTrue(isAllSubmitScene)) {
                    // 存储全量数据 -- 只针对于列表
                    mobilePageRawData.setAllRawMap(data);
                }
                // 表示整体数据是数组
                dataList = (List<Map<String, Object>>) UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
            }
        } else {
            // 非任务详情页渲染
            mobilePageRawData.setRawMap(data);
            // 表示对象中schema值是是数组
            dataList = (List<Map<String, Object>>) UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
        }

        //  特殊处理 --- 必须放在筛选逻辑前面
        if (PcmFilterUtil.isPcmCustomized(executeContext.getTmActivityId(), executeContext.getTmProjectId())) {
            // PCM_项目预算签核定制 --- 过滤数据
            dataList = this.customizePcmBudgetProjectApprovals(this.cardListData, dataList);
            // PCM获取任务信息
            this.customizePcmBudgetProjectApprovalsTaskInfo(this.cardListData, dataList, executeContext);
        }

        // 筛选
        if (BooleanUtils.isTrue(canFilterCard)) {
            // 获取表数据 user_card_list_filter
            Map<String, Object> userCardListFilterData = getUserCardListFilterData(this.filterCardButton, this.componentId, executeContext);
            this.filterCondition = userCardListFilterData;

            Button<UiBotAction> button = new Button<>();
            button.setSubmitAction(this.filterCardButton);
            // 筛选按钮暂不优化
            cmptContext.setCommonRawDataParentType(null);
            // 按钮组件
            button.handleComponentParam(cmptContext, mobilePath, schema, userCardListFilterData, executeContext, mobilePageRawData.deepCopy().setComponentId(this.componentId));
            cmptContext.setCommonRawDataParentType(CommonRawDataParentType.ALONE_LIST.getValue());
            this.filterAction = button.getAction();
            this.filterFlag = !CollectionUtils.isEmpty(userCardListFilterData);
            if (!this.filterFlag) {
                // filterFlag=false,首次默认弹出筛选框，控制当前页面下只有一个为false
                if (BooleanUtils.isFalse(cmptContext.getCardListGlobalFilterFlag())) {
                    this.filterFlag = true;
                } else {
                    // filterFlag 为false 首次进来就会默认展示筛选
                    this.filterFlag = BooleanUtils.isTrue(showInitFilter) ? false : true;
                    if (BooleanUtils.isFalse(this.filterFlag)) {
                        cmptContext.setCardListGlobalFilterFlag(false);
                    }
                }
                if (BooleanUtils.isTrue(showInitFilter)) {
                    // 默认弹起筛选页面时，不展示cardList
                    dataList = new ArrayList<>();
                }
            }

            // cardList 数据 筛选逻辑处理
            dataList = handleDataFiltration(dataList, userCardListFilterData);
        }

        // 构建table
        this.tableAction = this.buildTableAction(this.cardListData, dataList, executeContext.getLocale());
        Card.DesignerRawCard designerRawCard = Optional.ofNullable(cardListData).map(Card::getData).orElse(null);
        Boolean isDefaultSeq = isDefauleTableSeq(designerRawCard);
        if (!Objects.isNull(cardListData.getRawData())) {
            cardListData.getRawData().put("isDefaultTableSeq", isDefaultSeq);
        }

        // 构建分页配置
        this.pagingConfig = buildPagingConfig(cmptContext, executeContext, mobilePageRawData, this.cardListData,
                this.queryInfo, this.getComponentId(), this.returnComponentType());

        // 构建搜索配置
        this.searchConfig = handleSearchConfig(cmptContext, executeContext, mobilePageRawData, this.cardListData,
                this.canSearch, this.rawSearchConfig, this.getComponentId(), this.returnComponentType());
        if (this.searchConfig == null) {
            this.canSearch = false;
        }

        // 构建操作按钮
        this.operationButtons = buildOperationButtons(this.cardListData, executeContext, cmptContext, this.operations, mobilePageRawData, data, this.choice);
        this.hasOperationImport = isExistImport(operationButtons);

        //工具栏【新增按钮】数据格式转换
        convertCardListAdd(this.operations);

        if (BooleanUtils.isNotTrue(showInitFilter) && BooleanUtils.isNotTrue(canAddOrEditCard) && CollectionUtils.isEmpty(dataList)) {
            return;
        }
        // card构建
        this.data = new ArrayList<>();
        if (!CollectionUtils.isEmpty(dataList)) {

            // 卡片按钮的滑动特效开启处理
            handleCardButtonDetailPageSwiper();
            AtomicInteger index = new AtomicInteger(0);

            //卡片列表高级属性中，点击事件（onTap），标题点击事件（onTitleTap），子标题点击事件（onSubTitleTap） 目前设计器只能配置在cardList级别，但是运行态需要添加在每个卡片的高级属性中
            Map<String, Object> configCardListButBelongCardHooks;
            if (!CollectionUtils.isEmpty(this.getHooks())) {
                List<String> supportConfigCardListButBelongCard = Lists.newArrayList("onTap", "onTitleTap", "onSubTitleTap");
                configCardListButBelongCardHooks = this.getHooks().entrySet().stream().filter(entry -> supportConfigCardListButBelongCard.contains(entry.getKey()))
                        .collect(Collectors.toMap(entry -> entry.getKey(), entry -> entry.getValue(), (v1, v2) -> v1));
            } else {
                configCardListButBelongCardHooks = null;
            }

            dataList.forEach(r -> {
                // 拷贝，更改内存地址
                Card card = JsonUtil.objectToJavaObject(this.cardListData, Card.class);
                card.beforeHandleAttribute(this.buttonLayoutType);
                card.handleComponentParam(cmptContext, null, null, r, executeContext, mobilePageRawData);

                // 点击事件（onTap），标题点击事件（onTitleTap），子标题点击事件（onSubTitleTap）添加到每个卡片的高级属性中
                if (!CollectionUtils.isEmpty(configCardListButBelongCardHooks)) {
                    if (Objects.isNull(card.getHooks())) {
                        Map<String, Object> hooks = new HashMap<>();
                        hooks.put("eventSourceType", "component");
                        hooks.put("eventSource", card.getCmptUuid());
                        hooks.putAll(configCardListButBelongCardHooks);
                        card.setHooks(hooks);
                    } else {
                        card.getHooks().putAll(configCardListButBelongCardHooks);
                    }
                }

                if (Objects.isNull(card.getRawData()) || Objects.isNull(card.getRawData().get("isDefaultTableSeq"))) {
                    r.put(PcUiBotConstants.MOBILE_TABLE_SEQ, index.getAndIncrement());
                } else {
                    if ((Boolean) card.getRawData().get("isDefaultTableSeq")) {
                        r.put(PcUiBotConstants.MOBILE_TABLE_SEQ, index.getAndIncrement());
                    } else {
                        r.put(PcUiBotConstants.MOBILE_TABLE_SEQ, card.getSeq());
                    }
                }

                this.data.add(card);
            });
        }

        // cardList 新增
        if (BooleanUtils.isTrue(canAddOrEditCard)) {
            this.getAddItemAction(cmptContext, mobilePath, schema, executeContext, mobilePageRawData);
            List<ActionSubmitParam> cardList = new ArrayList<>();
            if (!CollectionUtils.isEmpty(this.data)) {
                this.data.forEach(card -> {
                    Card cardParam = new Card();
                    cardParam.setDataId(card.getDataId());
                    cardParam.setRawData(card.getRawData());
                    ActionSubmitParam actionSubmitParam = new ActionSubmitParam(card.getDataId(),
                            "DW_" + Card.COMPONENT_TYPE, card.getSchema(), card.getMobilePath(), cardParam);
                    cardList.add(actionSubmitParam);
                });
            } else {
                // 单身新增没有元数据，新增一条，为了使UiBotDesignerRenderService.handleAddCardListDataOfPageData方法中getSubmitParams有值，并需根据type与params=null移除
                ActionSubmitParam actionSubmitParam = new ActionSubmitParam(null, "DW_" + Card.COMPONENT_TYPE, schema, mobilePath, null);
                cardList.add(actionSubmitParam);
            }
            cmptContext.getCardAllDataList().addAll(cardList);
            this.cardAllDataList = cmptContext.getCardAllDataList();
        } else {
            List<ActionSubmitParam> cardList = new ArrayList<>();
            if (!CollectionUtils.isEmpty(this.data)) {
                this.data.forEach(card -> {
                    Card cardParam = new Card();
                    cardParam.setDataId(card.getDataId());
                    cardParam.setRawData(card.getRawData());
                    ActionSubmitParam actionSubmitParam = new ActionSubmitParam(card.getDataId(),
                            "DW_" + Card.COMPONENT_TYPE, card.getSchema(), card.getMobilePath(), cardParam);
                    cardList.add(actionSubmitParam);
                });
            }
            cmptContext.getCardAllDataList().addAll(cardList);
            this.cardAllDataList = cmptContext.getCardAllDataList();
        }
        this.isCheckList = this.getIsCheckList(this.cardListData, this.isCheckList);
        this.seqType = this.getSeqType(this.cardListData);
        // clear
        this.cardListData = null;
        this.filterCardButton = null;
        this.addCardButton = null;
        this.queryInfo = null;
        this.rawSearchConfig = null;
    }

    public static PagingConfig buildPagingConfig(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData,
                                                 Card cardListData, PcUiBotQueryInfo queryInfo,
                                                 String componentId, String componentType) {
        if (queryInfo == null || queryInfo.getPageInfo() == null || queryInfo.getPageInfo().getPageSize() == null) {
            // 不分页
            return null;
        }
        // 获取当前组件使用的数据源（可能不是主数据源）
        PcUiBotDataSourceSetDTO dataSourceSet = getCurrentDataSourceSet(cmptContext, cardListData, executeContext);
        if (dataSourceSet == null) {
            // 没有数据源
            return null;
        }

        PagingConfig pagingConfig = new PagingConfig();
        pagingConfig.setUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/component/data/query");
        pagingConfig.setPageInfo(queryInfo.getPageInfo());
        pagingConfig.setRawData(buildCommonQueryRawData(cmptContext, executeContext, mobilePageRawData, componentId, componentType, dataSourceSet));
        return pagingConfig;
    }

    private static PcUiBotDataSourceSetDTO getCurrentDataSourceSet(ComponentContext cmptContext, Card cardListData, PcUiBotExecuteContext executeContext) {
        DataSource dataSource = Optional.ofNullable(cardListData).map(Card::getData).map(Card.DesignerRawCard::getDataSource).orElse(null);
        return getCurrentDataSourceSet(cmptContext, dataSource, executeContext);
    }

    public static PcUiBotDataSourceSetDTO getCurrentDataSourceSet(ComponentContext cmptContext, DataSource dataSource, PcUiBotExecuteContext executeContext) {
        // 获取数据源名称
        String dataSourceName = Optional.ofNullable(dataSource)
                .map(DataSource::getActionName)
                // actionName为空时，使用主数据源名称
                .map(r -> StringUtils.hasLength(r) ? r : null)
                .orElse(executeContext.getMainDataSourceName());
        // 获取当前组件使用的数据源（可能不是主数据源）
        return Optional.ofNullable(cmptContext)
                .map(ComponentContext::getPageDefine)
                .map(PcUiBotPageDefine::getAllDataSourceSet)
                .map(PcUiBotDataSourceSetDTO::getDataSourceList)
                .orElse(Collections.emptyList()).stream()
                .filter(item -> Objects.equals(dataSourceName, item.getName()))
                .findFirst()
                .map(PcUiBotDataSourceSetDTO::create)
                .orElse(null);
    }

    private static Map<String, Object> buildCommonQueryRawData(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData, String componentId, String componentType, PcUiBotDataSourceSetDTO dataSourceSet) {
        Map<String, Object> rawData = new HashMap<>();
        // 分页接口使用
        rawData.put("dataSourceSet", dataSourceSet);

        // 渲染组件时使用（/mobile/v1/proxy/getCardListDslData）
        ComponentDslDataRequest dslDataRequest = new ComponentDslDataRequest();
        dslDataRequest.setExecuteContext(executeContext);

        ApiRawData apiRawData = new ApiRawData();
        apiRawData.put("sourceCategory", mobilePageRawData.getSourceCategory());
        dslDataRequest.setRawData(apiRawData);
        dslDataRequest.setPageId(cmptContext.getPageId());
        dslDataRequest.setComponentType("DW_" + componentType);
        dslDataRequest.setCmptUuid(componentId);
        // data 不用传递，会调用分页接口获取data，然后在传递渲染组件
        dslDataRequest.setData(null);
        //数据录入2.0浏览页非默认tab如果配置了搜索，查询任务定义需要viewCode来查询apgeUiElements
        dslDataRequest.setViewCode(Optional.ofNullable(JsonUtil.objectToJavaObject(cmptContext.getPageDefine(), PcUiBotDataViewPageDefine.class)).map(PcUiBotDataViewPageDefine::getViewCode).orElse(null));

        rawData.putAll(JsonUtil.objectToJavaObject(dslDataRequest, new TypeReference<Map<String, Object>>() {
        }));
        return rawData;
    }

    public static SearchConfig handleSearchConfig(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData,
                                                  Card cardListData, Boolean canSearch, RawSearchConfig rawSearchConfig,
                                                  String componentId, String componentType) {
        if (BooleanUtils.isNotTrue(canSearch) || rawSearchConfig == null) {
            // 无搜索配置
            return null;
        }
        List<PcUiBotActionSearchInfoMapping> searchInfo = buildSearchInfo(rawSearchConfig.getSearchInfo());
        if (CollectionUtils.isEmpty(searchInfo)) {
            // 无搜索配置
            return null;
        }
        SearchConfig searchConfig = new SearchConfig();
        searchConfig.setPlaceholder(rawSearchConfig.getPlaceholder());
        searchConfig.setUseHasNext(rawSearchConfig.getUseHasNext());
        searchConfig.setShowSearch(rawSearchConfig.getShowSearch());
        searchConfig.setSearchInfo(searchInfo);
        if (BooleanUtils.isNotTrue(searchConfig.getUseHasNext())) {
            // 前端搜索
            return searchConfig;
        }

        // 获取当前组件使用的数据源（可能不是主数据源）
        PcUiBotDataSourceSetDTO dataSourceSet = getCurrentDataSourceSet(cmptContext, cardListData, executeContext);
        if (dataSourceSet == null) {
            // 没有数据源
            return null;
        }

        // 后端搜索
        searchConfig.setUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/component/data/query");
        searchConfig.setRawData(buildCommonQueryRawData(cmptContext, executeContext, mobilePageRawData, componentId, componentType, dataSourceSet));
        return searchConfig;
    }

    private static List<PcUiBotActionSearchInfoMapping> buildSearchInfo(List<Card.DesignerRawCard.Content> searchInfo) {
        if (CollectionUtils.isEmpty(searchInfo)) {
            return new ArrayList<>();
        }
        return searchInfo.stream().map(search -> {
            PcUiBotActionSearchInfoMapping searchInfoMapping = new PcUiBotActionSearchInfoMapping();
            searchInfoMapping.setSearchField(search.getSchema());
            searchInfoMapping.setSearchOperator(Optional.ofNullable(search.getSetting()).map(setting -> MapUtils.getString((Map<String, Object>) setting, "searchOperator", "")).orElse(""));
            searchInfoMapping.setDataType(search.getData_type());
            return searchInfoMapping;
        }).filter(e -> StringUtils.hasLength(e.getSearchOperator())).collect(Collectors.toList());
    }

    private Boolean isDefauleTableSeq(Card.DesignerRawCard designerRawCard) {
        if (!Objects.isNull(designerRawCard)) {
            Card.DesignerRawCard.SeqConfig seqConfig = designerRawCard.getSeqConfig();
            if (!Objects.isNull(seqConfig)) {
                if (BooleanUtils.isFalse(seqConfig.getIsDefaultSeq())) {
                    return false;
                }
            }
        }
        return true;
    }

    public static Map<String, Object> buildCommonChildRawData(PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        Map<String, Object> rawData = new HashMap<>();
        rawData.put("allRawMap", mobilePageRawData.getAllRawMap());
        rawData.put("rawMap", mobilePageRawData.getRawMap());
        rawData.put("rawDataType", mobilePageRawData.getRawDataType());
        rawData.put("baseEntryExtendedFields", mobilePageRawData.getExtendedFields());
        rawData.put("sourceCategory", mobilePageRawData.getSourceCategory());
        rawData.put("dataKeys", mobilePageRawData.getDataKeys());
        rawData.put("componentId", mobilePageRawData.getComponentId());
        // rawdata中存入代理token，此值在拦截器中处理
        rawData.put("digi-proxy-token", AppRequestContext.getContextEntity().getProxyToken());
        rawData.put("executeContext", executeContext);
        return rawData;

    }

    public static Map<String, Object> getUserCardListFilterData(UiBotAction filterCardButton, String componentId, PcUiBotExecuteContext executeContext) {
        // 根据tenantId、userId、tmActivityId、dataId、pageId、componentId 查询数据库，获取过滤条件
        // 筛选页面pageId
        String pageId = Optional.ofNullable(filterCardButton).map(UiBotAction::getJumpAction).map(UiBotJumpAction::getJumpPageId).orElse("");
        if (!StringUtils.hasLength(pageId) || !StringUtils.hasLength(componentId)) {
            return new HashMap<>();
        }
        UserCardListFilter userCardListFilter = SpringContextHolder.getBean(UserCardListFilterService.class)
                .getUserCardListFilter(new UserCardListFilterQueryDTO()
                        .setTenantId(AppRequestContext.getContextEntity().getTenantId())
                        .setUserId(AppRequestContext.getContextEntity().getUserId())
                        .setTmActivityId(executeContext.getTmActivityId())
                        .setDataId(executeContext.getMobileDataId())
                        .setPageId(pageId)
                        .setComponentId(componentId));
        if (userCardListFilter == null || !StringUtils.hasLength(userCardListFilter.getData())) {
            return new HashMap<>();
        }
        try {
            Map<String, Object> map = JsonUtil.jsonStringToObject(userCardListFilter.getData(), new TypeReference<Map<String, Object>>() {
            });
            //  过滤掉值为0的key
            map.entrySet().removeIf(entry -> NumberUtils.isCreatable(StringUtil.valueOf(entry.getValue())) && BigDecimal.ZERO.compareTo(new BigDecimal(StringUtil.valueOf(entry.getValue()))) == 0);
            return map;
        } catch (Exception e) {
            return new HashMap<>();
        }
    }

    public static List<Map<String, Object>> handleDataFiltration(List<Map<String, Object>> dataList, Map<String, Object> userCardListFilterData) {
        if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_STAND_PRODUCTION_PROGRESS_PAGE.toString().equals(AppRequestContext.getContextEntity().getPageId())) {
            // APC-机位生产进度页面，走接口过滤，故无需走本地过滤
            // wjw TODO: 2024/8/13 --- 后续需去除本地过滤,因本地过滤已走前端处理
            return dataList;
        }
        if (CollectionUtils.isEmpty(dataList)) {
            return dataList;
        }
        if (CollectionUtils.isEmpty(userCardListFilterData)) {
            return dataList;
        }
        return dataList.stream().filter(item -> userCardListFilterData.entrySet().stream()
                .allMatch(entry -> {
                    String key = entry.getKey();
                    String value = StringUtil.valueOf(entry.getValue());
                    if (!StringUtils.hasLength(value)) {
                        // 筛选条件空值不参与过滤
                        return true;
                    }
                    if (NumberUtils.isCreatable(value) && BigDecimal.ZERO.compareTo(new BigDecimal(value)) == 0) {
                        //  筛选条件0不参与过滤
                        return true;
                    }
                    if (key.startsWith("mobile_start_")) {
                        // 时间范围搜索 开始日期
                        key = key.substring("mobile_start_".length());
                        String s = StringUtil.valueOf(item.get(key));
                        return StringUtils.hasLength(s) && DateUtil.parse(value).isBeforeOrEquals(DateUtil.parse(s));
                    }
                    if (key.startsWith("mobile_end_")) {
                        // 时间范围搜索 结束日期
                        key = key.substring("mobile_end_".length());
                        String s = StringUtil.valueOf(item.get(key));
                        return StringUtils.hasLength(s) && DateUtil.parse(value).isAfterOrEquals(DateUtil.parse(s));
                    }
                    if (key.contains("&&&&")) {
                        // 多字段模糊匹配
                        return Arrays.stream(key.split("&&&&")).anyMatch(k -> StringUtil.valueOf(item.get(k)).contains(value));
                    }
                    if (entry.getValue() instanceof List) {
                        List list = (List) entry.getValue();
                        // 筛选条件为列表，包含0说明重置状态，选择全部
                        if (CollectionUtils.isEmpty(list)) {
                            return true;
                        }

                        // 开窗多选条件匹配数据
                        if (list.get(0) instanceof Map) {
                            return list.stream().anyMatch(ListItem -> {
                                Map<String, Object> conditionMap = (Map) ListItem;
                                return conditionMap.entrySet().stream().anyMatch(e -> Objects.equals(e.getValue(), item.get(e.getKey())));
                            });
                        } else {
                            return ((List<String>) entry.getValue()).contains(StringUtil.valueOf(item.get(key)));
                        }
                    }

                    if (!item.containsKey(key)) {
                        // 筛选字段必须在元数据中
                        return true;
                    }
                    // 元数据值
                    Object itemValue = item.get(key);
                    if (itemValue == null) {
                        return false;
                    } else if (itemValue instanceof String) {
                        return StringUtil.valueOf(itemValue).contains(value);
                    } else if (itemValue instanceof Number && NumberUtils.isCreatable(value)) {
                        return new BigDecimal(StringUtil.valueOf(itemValue)).compareTo(new BigDecimal(value)) == 0;
                    } else if (itemValue instanceof Boolean) {
                        return StringUtil.valueOf(itemValue).equals(value);
                    } else if (itemValue instanceof Date) {
                        return true;
                    } else if (itemValue instanceof List) {
                        return true;
                    } else if (itemValue instanceof Map) {
                        return true;
                    } else {
                        return StringUtil.valueOf(itemValue).contains(value);
                    }
                })).collect(Collectors.toList());
    }

    private Integer getSeqType(Card cardListData) {
        Card.DesignerRawCard.SeqConfig seqConfig = Optional
                .ofNullable(cardListData)
                .map(Card::getData)
                .map(Card.DesignerRawCard::getSeqConfig)
                .orElse(null);
        if (ObjectUtils.isEmpty(seqConfig)) {
            return 0;
        } else if (BooleanUtils.isFalse(seqConfig.getIsDefaultSeq())
                && (!StringUtils.hasLength(seqConfig.getSeqName()) || !StringUtils.hasLength(seqConfig.getSeqNamePath()))) {
            return 0;
        }
        return seqConfig.getSeqStyleType();
    }

    private Action<CardListToTableRawData> buildTableAction(Card cardListData, List<Map<String, Object>> dataList, String locale) {
        boolean showTable = Optional.ofNullable(cardListData).map(Card::getData).map(Card.DesignerRawCard::getShowTable).orElse(false);
        if (!showTable) {
            return null;
        }
        Action<CardListToTableRawData> action = new Action<>();
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_CARDLIST_CONVERT_TABLE_PAGE.name());
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        CardListToTableRawData rawData = new CardListToTableRawData();
        action.setRawData(rawData);

        rawData.setDataList(dataList);
        Card.DesignerRawCard.TableConfig tableConfig = Optional.ofNullable(cardListData).map(Card::getData).map(Card.DesignerRawCard::getTableConfig).orElse(null);
        if (tableConfig != null) {
            tableConfig.setDefaultLandscape(true);
            tableConfig.setIsLandscape(false);
            if (tableConfig.getRowIndex()) {
                //增加表头
                List<Card.DesignerRawCard.Content> contents = tableConfig.getContent();
                if (!CollectionUtils.isEmpty(contents)) {
                    Card.DesignerRawCard.Content headContent = new Card.DesignerRawCard.Content();
                    headContent.setLabel(localeService.getLanguageValue(locale, "序号"));
                    headContent.setSchema(PcUiBotConstants.MOBILE_TABLE_SEQ);
                    contents.add(0, headContent);
                }
            }
        }
        rawData.setTableConfig(tableConfig);

        return action;
    }

    private List<Map<String, Object>> customizePcmBudgetProjectApprovals(Card cardListData, List<Map<String, Object>> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return dataList;
        }
        // wjw TODO: 2024/4/10 卡片列表过滤数据，先使用DesignerRawCard.getProcessedConditionList属性来过滤(因发现此属性不是作用于过滤数据场景)
        List<CardProcessedCondition> processedConditions = Optional
                .ofNullable(cardListData)
                .map(Card::getData)
                .map(Card.DesignerRawCard::getProcessedConditionList)
                .orElse(null);
        if (CollectionUtils.isEmpty(processedConditions)) {
            return dataList;
        }
        CardProcessedCondition cardProcessedCondition = processedConditions.get(0);
        dataList = dataList.stream().filter(data -> Optional.ofNullable(cardProcessedCondition.getValue()).orElse("").equals(data.get(cardProcessedCondition.getSchema()))).collect(Collectors.toList());
        // 重置序号
        if (!CollectionUtils.isEmpty(dataList)) {
            for (int i = 0; i < dataList.size(); i++) {
                dataList.get(i).put("seq", i + 1);
            }
        }
        return dataList;
    }

    private void customizePcmBudgetProjectApprovalsTaskInfo(Card cardListData, List<Map<String, Object>> dataList, PcUiBotExecuteContext executeContext) {
        String nodePath = Optional.ofNullable(cardListData).map(Card::getData).map(Card.DesignerRawCard::getNodePath).orElse("");
        if (!"project_budget_info.project_expense_budget_detail.project_expense_task_detail".equals(nodePath)) {
            // 非费用子项
            return;
        }
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        Map<String, Object> bpmData = Optional.ofNullable(executeContext.getBpmData()).orElse(new HashMap<>());
        Map<String, Object> parameter = new HashMap<>(2);
        // ALL.全部；M1.任务；D1.任务依赖关系；D2.任务执行人；D3.任务报工
        parameter.put("query_condition", "M1");
        Map<String, Object> taskInfo = new HashMap<>(1);
        taskInfo.put("project_no", bpmData.get("project_no"));
        parameter.put("task_info", Lists.newArrayList(taskInfo));
        DigiwinAtdmRequest request = DigiwinAtdmRequest.create("bm.pisc.task.get",
                parameter,
                JsonUtil.objectToJavaObject(executeContext, Map.class),
                JsonUtil.objectToJavaObject(executeContext.getBusinessUnit(), Map.class)
        );
        DigiwinAthenaApiResponse<Map<String, Object>> athenaApiResponse = SpringContextHolder.getBean(DigiwinAtdmProxyService.class)
                .dataQueryByActionId(
                        AppRequestContext.getContextEntity().getLocale(),
                        AppRequestContext.getContextEntity().getIamUserToken(),
                        JsonUtil.javaObjectToJsonString(request),
                        AppRequestContext.getContextEntity().getTenantId()
                );
        if (athenaApiResponse == null) {
            return;
        }
        Map<String, Object> map = athenaApiResponse.getResponse();
        if (map == null) {
            return;
        }
        List<Map<String, Object>> taskInfoList = (List<Map<String, Object>>) map.get("task_info");
        if (CollectionUtils.isEmpty(taskInfoList)) {
            return;
        }
        Map<String, Map<String, Object>> taskNoMap = taskInfoList.stream().collect(Collectors.toMap(key -> StringUtil.valueOf(key.get("task_no")), c -> c, (c1, c2) -> c1));
        // 将任务数据存储data中
        dataList.forEach(r -> {
            r.put("task_name", taskNoMap.get(StringUtil.valueOf(r.get("task_no"))) == null ? "" : StringUtil.valueOf(taskNoMap.get(StringUtil.valueOf(r.get("task_no"))).get("task_name")));
            r.put("mobile_task_no", taskNoMap);
        });
    }

    public Boolean getIsCheckList(Card cardListData, Boolean isCheckList) {
        List<CardProcessedCondition> processedConditions = Optional
                .ofNullable(cardListData)
                .map(Card::getData)
                .map(Card.DesignerRawCard::getProcessedConditionList)
                .orElse(null);
        // wjw FIXME: 2024/1/30 不为空，说明开启了校验，故设置true；为空时，说明设计器未配置或代码中赋值的(如line场景)，故设置原有值
        return CollectionUtils.isEmpty(processedConditions) ? isCheckList : true;
    }

    /**
     * 卡片按钮滑动特效开启处理
     * 目前多个按钮只能支持开启一个按钮的滑动特效
     */
    private void handleCardButtonDetailPageSwiper() {
        List<UiBotAction> buttonList = Optional.ofNullable(this.cardListData).map(Card::getData)
                .map(Card.DesignerRawCard::getButtonList).orElse(new ArrayList<>());
        // 子标题按钮
//            Optional.ofNullable(this.cardListData).map(Card::getData).map(Card.DesignerRawCard::getSubTitleButton).ifPresent(buttonList::add);
        //判断卡片上的新增按钮是否有滑动特效(新：type=20，旧：detailPageSwiper=true)
        boolean isButtonDetailPageSwiperOpen = buttonList.stream().anyMatch(e -> {
            Boolean detailPageSwiper = Optional.ofNullable(e.getJumpAction()).map(UiBotJumpAction::getDetailPageSwiper).orElse(false);
            Boolean newDetailPageSwiper = Optional.ofNullable(e.getJumpAction())
                    .map(UiBotJumpAction::getType)
                    .map(type -> Objects.equals(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM_SWIPER.getValue(), type))
                    .orElse(false);
            return BooleanUtils.isTrue(detailPageSwiper) || BooleanUtils.isTrue(newDetailPageSwiper);
        });


        Card.DesignerRawCard.DetailPage detailPage = Optional.ofNullable(this.cardListData).map(Card::getData).map(Card.DesignerRawCard::getDetailPage).orElse(null);
        if (isButtonDetailPageSwiperOpen) {
            this.detailPageSwiper = true;
            AtomicReference<String> pageId = new AtomicReference<>("");
            //统一按钮上的type统一处理，detailPageSwiper=true或type=20的情况下的情况
            buttonList.forEach(e -> {
                UiBotJumpAction uiBotJumpAction = e.getJumpAction();
                if (ObjectUtils.isNotEmpty(uiBotJumpAction) && BooleanUtils.isTrue(uiBotJumpAction.getDetailPageSwiper()) ||
                        Objects.equals(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM_SWIPER.getValue(), uiBotJumpAction.getType())) {
                    uiBotJumpAction.setType(ActionTypeEnum.CUSTOMIZE_POPUP_DISPLAYS_PAGE.getValue());
                    e.setJumpAction(uiBotJumpAction);
                    pageId.set(uiBotJumpAction.getJumpPageId());
                }
            });
            if (Objects.isNull(detailPage)) {
                detailPage = new Card.DesignerRawCard.DetailPage();
            }
            if (Objects.nonNull(this.cardListData)) {
                this.detailPageSwiper = true;
                this.cardListData.setCardButtons(null);
                this.cardListData.getCardButtons();
                if (BooleanUtils.isTrue(detailPage.getDetailPageSwiper()) ||
                        ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM_SWIPER.getValue().equals(detailPage.getType())) {
                    //按钮和卡片上都有滑动特效，opentailType给0且卡片列表的detailPageSwiper为true
                    this.cardListData.getData().setOpenDetailType(CardOpenDetailTypeEnum.BY_BUTTON_AND_CARD.getValue());
                } else {
                    //按钮有滑动特效，卡片没有滑动特效，但是有配置，opentailType给2，
                    this.cardListData.getData().setOpenDetailType(CardOpenDetailTypeEnum.BY_BUTTON.getValue());
                    Card.DesignerRawCard.DetailPage cardAction = new Card.DesignerRawCard.DetailPage();
                    //卡片的跳转配置赋值给临时变量，用于构建普通跳转的cardAction
                    cardAction.setType(detailPage.getType());
                    cardAction.setDetailPageSwiper(false);
                    cardAction.setPageId(detailPage.getPageId());
                    this.cardListData.getData().setCardAction(cardAction);
                }
                // 统一构建detailPage，按钮和卡片上都有滑动特效的时候，则按钮的滑动特效会覆盖卡片的
                detailPage.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                detailPage.setDetailPageSwiper(true);
                detailPage.setPageId(pageId.get());
                this.cardListData.getData().setDetailPage(detailPage);
            }
        } else {
            if (Objects.isNull(detailPage)) {
                detailPage = new Card.DesignerRawCard.DetailPage();
            }
            if (Objects.nonNull(this.cardListData)) {
                if (BooleanUtils.isTrue(detailPage.getDetailPageSwiper()) ||
                        ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM_SWIPER.getValue().equals(detailPage.getType())) {
                    //按钮没有滑动特效，卡片有滑动特效，opentailType给1且卡片列表的detailPageSwiper为true
                    this.detailPageSwiper = true;
                    this.cardListData.getData().setOpenDetailType(CardOpenDetailTypeEnum.BY_CARD.getValue());
                } else {
                    //两者都没有滑动特效
                    this.detailPageSwiper = false;
                    this.cardListData.getData().setOpenDetailType(null);
                    Card.DesignerRawCard.DetailPage cardAction = new Card.DesignerRawCard.DetailPage();
                    //卡片的跳转配置赋值给临时变量，用于构建普通跳转的cardAction
                    cardAction.setType(detailPage.getType());
                    cardAction.setDetailPageSwiper(false);
                    cardAction.setPageId(detailPage.getPageId());
                    this.cardListData.getData().setCardAction(cardAction);
                }
            }
        }
    }

    public static boolean isChildNode(String mobilePath, String schema) {
        String path = schema;
        if (StringUtils.hasLength(mobilePath)) {
            path = mobilePath;
        }
        if (!StringUtils.hasLength(path)) {
            return false;
        }
        if (!path.contains(".")) {
            return false;
        }
        return true;
    }

    public static void handleRawCardListData(Card cardListData, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        if (!PcUiBotPatternUtil.isBaseData(executeContext.getPattern())) {
            // 不是基础数据录入，返回
            return;
        }
        BaseDataStatusConfig statusConfig = JsonUtil.objectToJavaObject(mobilePageRawData.getExtendedFields(), BaseDataStatusConfig.class);
        if (statusConfig == null || BooleanUtils.isNotTrue(statusConfig.getNeedStatusColumn())) {
            return;
        }
        List<Map<String, Object>> stateConfig = statusConfig.getStateConfig();
        if (CollectionUtils.isEmpty(stateConfig)) {
            return;
        }
        Card.DesignerRawCard.Content content = new Card.DesignerRawCard.Content();
        content.setSchema(PcUiBotTagConstant.MANAGE_STATUS);
        content.setType("TAG");
        Card.DesignerRawCard.TagSettingModel setting = new Card.DesignerRawCard.TagSettingModel();
        content.setSetting(setting);
        setting.setMatchType(1);
        setting.setSpliceSource(2);
        List<Card.DesignerRawCard.TagSettingModel.Option> optionList = new ArrayList<>();
        setting.setOptions(optionList);
        stateConfig.forEach(state -> {
            Card.DesignerRawCard.TagSettingModel.Option option = new Card.DesignerRawCard.TagSettingModel.Option();
            option.setId(StringUtil.valueOf(state.get("value")));
            option.setText(getText(state));
            // 样式
            String theme = StringUtil.valueOf(state.get("theme"));
            if ("danger".equals(theme)) {
                // 失效 -- danger
                option.setStyleType(Tag.TagType.HIGH_RISK.getValue());
            } else if ("success".equals(theme)) {
                // 生效 -- success
                option.setStyleType(Tag.TagType.LOW_RISK.getValue());
            } else {
                // 未生效 -- warning
                option.setStyleType(Tag.TagType.MEDIUM_RISK.getValue());
            }
            optionList.add(option);
        });
        if (cardListData == null || cardListData.getData() == null) {
            return;
        }
        List<Card.DesignerRawCard.Content> contentList = cardListData.getData().getContent();
        if (CollectionUtils.isEmpty(contentList)) {
            contentList = new ArrayList<>();
        }
        contentList.add(content);
        cardListData.getData().setContent(contentList);
    }

    private static String getText(Map<String, Object> state) {
        String value = StringUtil.valueOf(state.get("title"));
        Map<String, Object> language = (Map<String, Object>) state.get("language");
        if (CollectionUtils.isEmpty(language)) {
            return value;
        }
        Map<String, Object> title = (Map<String, Object>) language.get("title");
        if (CollectionUtils.isEmpty(title)) {
            return value;
        }
        return StringUtil.valueOf(title.get(AppRequestContext.getContextEntity().getLocale()));
    }

    private void convertCardListAdd(List<PcUiBotTmOperation> operations) {
        if (CollectionUtils.isEmpty(operations)) {
            return;
        }
        for (PcUiBotTmOperation operation : operations) {
            if ("card_list_add".equals(operation.getType())) {
                PcUiBotTmOperation.CardListAddObj cardListAddObj = JsonUtil.objectToJavaObject(operation.getSetting(), PcUiBotTmOperation.CardListAddObj.class);
                if (BooleanUtils.isTrue(cardListAddObj.getCanAddOrEditCard())) {
                    this.addCardType = cardListAddObj.getAddCardType();
                    this.canAddOrEditCard = cardListAddObj.getCanAddOrEditCard();
                    this.addCardButton = cardListAddObj.getAddCardButton();
                    this.canShowBottom = cardListAddObj.getCanShowBottom();
                }
            }
        }
        this.operations = null;
    }

    /**
     * 检查cardList组件下card内容content是否包含编辑栏位
     */
//    public Boolean checkContentContainsEditable() {
//        if (this.cardListData == null || this.cardListData.getData() == null) {
//            return false;
//        }
//        List<Card.DesignerRawCard.Content> contentList = this.cardListData.getData().getContent();
//        if (CollectionUtils.isEmpty(contentList)) {
//            return false;
//        }
//        return contentList.stream().anyMatch(content -> BooleanUtils.isTrue(content.getEditable()));
//    }


}