package com.digiwin.mobile.mobileuibot.core.component.logistics;

import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbUserAddress;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.AsnHeaderResponse;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.*;

/**
 * 物流组件
 *
 * @author wuyang
 * @time 20220914
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Logistics extends BaseMobileComponent implements Serializable {

    public static final String COMPONENT_TYPE = "LOGISTICS";
    private static final long serialVersionUID = -3306420354377092061L;
    /**
     * 组件对应的字段
     */
    protected String schema;
    /**
     * 是否隐藏
     */
    protected Boolean hidden;
    protected Boolean enable;
    protected Boolean required;
    private List<LogisticsData> logisticsDataList;


    public static Logistics create(String schema, String locale, AsnHeaderResponse asnHeaderResponse, Boolean useAddressBook) {
        Logistics logistics = new Logistics();
        List<LogisticsData> logisticsDataList = new ArrayList<>(2);
        logistics.setLogisticsDataList(logisticsDataList);
        logistics.setSchema(schema);
        logistics.setHidden(false);
        logistics.setEnable(true);
        if (asnHeaderResponse == null) {
            return logistics;
        }
        LogisticsData sendData = new LogisticsData();
        sendData.setId(asnHeaderResponse.getDeliveryAddressId());
        sendData.setCompleteAddress(asnHeaderResponse.getDeliveryAddress());
        sendData.setName(asnHeaderResponse.getShipperName());
        if (StringUtils.hasLength(asnHeaderResponse.getShipperMobile())) {
            sendData.setMobile(asnHeaderResponse.getShipperMobile());
            if (!useAddressBook) {
                sendData.setPhoneIcon(58908);
            }

        } else {
            sendData.setMobile("-");
        }
        Map<String, Object> sendRawData = new HashMap<>(3);
        Boolean sendHaveEmpty = false;
        if (StringUtils.hasLength(asnHeaderResponse.getDeliveryAddress())) {
            sendRawData.put("complete_address", asnHeaderResponse.getDeliveryAddress());
        } else {
            sendHaveEmpty = true;
        }
        if (StringUtils.hasLength(asnHeaderResponse.getShipperMobile())) {
            sendRawData.put("user_phone", asnHeaderResponse.getShipperMobile());
        } else {
            sendHaveEmpty = true;
        }
        if (StringUtils.hasLength(asnHeaderResponse.getShipperName())) {
            sendRawData.put("user_name", asnHeaderResponse.getShipperName());
        } else {
            sendHaveEmpty = true;
        }
        if (sendHaveEmpty) {
            sendData.setPlaceholderAddress(LocaleUtil.getMobileTextByKey(locale, "请填写详细地址、联系人、联系电话"));
            sendData.setPlaceholderName(LocaleUtil.getMobileTextByKey(locale, "发货信息"));
        }


        sendData.setType(LogisticsEnum.SEND.getValue());
        sendData.setIconName(LocaleUtil.getMobileTextByKey(locale, "发"));
        sendData.setUseAddressBook(useAddressBook);
        Map<String, Object> pageMap = new HashMap<>(2);
        pageMap.put("pageNo", "1");
        pageMap.put("pageSize", "9999");
        if (useAddressBook) {
            sendData.setModifiyAddress(Button.createModifiyAddress(UUIDUtil.getUuid(), sendRawData, locale, ""));
            sendData.setAddressBook(Button.createAddressBook(UUIDUtil.getUuid(), pageMap, locale));
        } else {
            sendData.setMapIcon(58948);
        }

        logisticsDataList.add(sendData);

        LogisticsData receiveData = new LogisticsData();
        receiveData.setId(asnHeaderResponse.getReceiptAddressId());
        receiveData.setCompleteAddress(asnHeaderResponse.getReceiptAddress());
        receiveData.setName(asnHeaderResponse.getReceiverName());
        if (StringUtils.hasLength(asnHeaderResponse.getReceiverMobile())) {
            receiveData.setMobile(asnHeaderResponse.getReceiverMobile());
            if (!useAddressBook) {
                receiveData.setPhoneIcon(58908);
            }
        } else {
            receiveData.setMobile("-");
        }

        Map<String, Object> receiveRawData = new HashMap<>(3);
        Boolean receiveHaveEmpty = false;
        if (StringUtils.hasLength(asnHeaderResponse.getReceiptAddress())) {
            receiveRawData.put("complete_address", asnHeaderResponse.getReceiptAddress());
        } else {
            receiveHaveEmpty = true;
        }
        if (StringUtils.hasLength(asnHeaderResponse.getReceiverMobile())) {
            receiveRawData.put("user_phone", asnHeaderResponse.getReceiverMobile());
        } else {
            receiveHaveEmpty = true;
        }
        if (StringUtils.hasLength(asnHeaderResponse.getReceiverName())) {
            receiveRawData.put("user_name", asnHeaderResponse.getReceiverName());
        } else {
            receiveHaveEmpty = true;
        }
        if (receiveHaveEmpty) {
            receiveData.setPlaceholderAddress(LocaleUtil.getMobileTextByKey(locale, "请填写详细地址、联系人、联系电话"));
            receiveData.setPlaceholderName(LocaleUtil.getMobileTextByKey(locale, "收货信息"));
        }

        receiveData.setType(LogisticsEnum.RECEIVER.getValue());
        receiveData.setIconName(LocaleUtil.getMobileTextByKey(locale, "收"));
        receiveData.setUseAddressBook(useAddressBook);
        if (useAddressBook) {
            receiveData.setModifiyAddress(Button.createModifiyAddress(UUIDUtil.getUuid(), receiveRawData,
                    locale, ""));
            receiveData.setAddressBook(Button.createAddressBook(UUIDUtil.getUuid(), pageMap, locale));
        } else {
            receiveData.setMapIcon(58948);
        }
        logisticsDataList.add(receiveData);

        logistics.setRequired(true);
        return logistics;
    }

    public static Logistics create(String schema, String locale, DigiwinTransportResponse transportMainInfo, Boolean useAddressBook) {
        Logistics logistics = new Logistics();
        List<LogisticsData> logisticsDataList = new ArrayList<>(2);
        logistics.setLogisticsDataList(logisticsDataList);
        logistics.setSchema(schema);
        logistics.setHidden(false);
        logistics.setEnable(true);
        if (transportMainInfo == null) {
            return logistics;
        }
        LogisticsData sendData = new LogisticsData();
        sendData.setCompleteAddress(transportMainInfo.getDeliveryAddress());
        sendData.setName(transportMainInfo.getShipperName());
        if (StringUtils.hasLength(transportMainInfo.getShipperMobile())) {
            sendData.setMobile(transportMainInfo.getShipperMobile());
            if (!useAddressBook) {
                sendData.setPhoneIcon(58908);
            }
        } else {
            sendData.setMobile("-");
        }
        Map<String, Object> sendRawData = new HashMap<>(3);
        Map<String, Object> pageMap = new HashMap<>(2);
        pageMap.put("pageNo", "1");
        pageMap.put("pageSize", "9999");
        Boolean sendHaveEmpty = false;
        if (StringUtils.hasLength(transportMainInfo.getDeliveryAddress())) {
            sendRawData.put("complete_address", transportMainInfo.getDeliveryAddress());
        } else {
            sendHaveEmpty = true;
        }
        if (StringUtils.hasLength(transportMainInfo.getShipperMobile())) {
            sendRawData.put("user_phone", transportMainInfo.getShipperMobile());
        } else {
            sendHaveEmpty = true;
        }
        if (StringUtils.hasLength(transportMainInfo.getShipperName())) {
            sendRawData.put("user_name", transportMainInfo.getShipperName());
        } else {
            sendHaveEmpty = true;
        }
        if (sendHaveEmpty) {
            sendData.setPlaceholderAddress(LocaleUtil.getMobileTextByKey(locale, "请填写详细地址、联系人、联系电话"));
            sendData.setPlaceholderName(LocaleUtil.getMobileTextByKey(locale, "发货信息"));
        }
        if (useAddressBook) {
            sendData.setModifiyAddress(Button.createModifiyAddress(UUIDUtil.getUuid(), sendRawData, locale, ""));
            sendData.setAddressBook(Button.createAddressBook(UUIDUtil.getUuid(), pageMap, locale));
        } else {
            sendData.setMapIcon(58948);
        }


        sendData.setType(LogisticsEnum.SEND.getValue());
        sendData.setIconName(LocaleUtil.getMobileTextByKey(locale, "发"));
        sendData.setUseAddressBook(useAddressBook);
        logisticsDataList.add(sendData);

        LogisticsData receiveData = new LogisticsData();
        receiveData.setCompleteAddress(transportMainInfo.getReceiptAddress());
        receiveData.setName(transportMainInfo.getReceiverName());
        if (StringUtils.hasLength(transportMainInfo.getReceiverMobile())) {
            receiveData.setMobile(transportMainInfo.getReceiverMobile());
            if (!useAddressBook) {
                receiveData.setPhoneIcon(58908);
            }
        } else {
            receiveData.setMobile("-");
        }

        Map<String, Object> receiveRawData = new HashMap<>(3);
        Boolean receiveHaveEmpty = false;
        if (StringUtils.hasLength(transportMainInfo.getReceiptAddress())) {
            receiveRawData.put("complete_address", transportMainInfo.getReceiptAddress());
        } else {
            receiveHaveEmpty = true;
        }
        if (StringUtils.hasLength(transportMainInfo.getReceiverMobile())) {
            receiveRawData.put("user_phone", transportMainInfo.getReceiverMobile());
        } else {
            receiveHaveEmpty = true;
        }
        if (StringUtils.hasLength(transportMainInfo.getReceiverName())) {
            receiveRawData.put("user_name", transportMainInfo.getReceiverName());
        } else {
            receiveHaveEmpty = true;
        }
        if (receiveHaveEmpty) {
            receiveData.setPlaceholderAddress(LocaleUtil.getMobileTextByKey(locale, "请填写详细地址、联系人、联系电话"));
            receiveData.setPlaceholderName(LocaleUtil.getMobileTextByKey(locale, "收货信息"));
        }
        if (useAddressBook) {
            receiveData.setModifiyAddress(Button.createModifiyAddress(UUIDUtil.getUuid(), receiveRawData, locale, ""));
            receiveData.setAddressBook(Button.createAddressBook(UUIDUtil.getUuid(), pageMap, locale));
        } else {
            receiveData.setMapIcon(58948);
        }


        receiveData.setType(LogisticsEnum.RECEIVER.getValue());
        receiveData.setIconName(LocaleUtil.getMobileTextByKey(locale, "收"));
        receiveData.setUseAddressBook(useAddressBook);

        logisticsDataList.add(receiveData);
        logistics.setRequired(true);

        return logistics;
    }

    public static Logistics create(String schema, String locale,
                                   Map<String, Object> deliverAddress, Map<String, Object> receiptAddress,
                                   Boolean useAddressBook) {
        Logistics logistics = new Logistics();
        List<LogisticsData> logisticsDataList = new ArrayList<>(2);
        logistics.setLogisticsDataList(logisticsDataList);
        logistics.setSchema(schema);
        logistics.setHidden(false);
        logistics.setEnable(true);
        if (deliverAddress == null || receiptAddress == null) {
            return logistics;
        }
        ZtbUserAddress deliverAddressData = JsonUtil.objectToJavaObject(deliverAddress, ZtbUserAddress.class);
        LogisticsData sendData = new LogisticsData();
        sendData.setCompleteAddress(deliverAddressData.getCompleteAddress());
        sendData.setName(deliverAddressData.getUserName());
        if (StringUtils.hasLength(deliverAddressData.getUserPhone())) {
            sendData.setMobile(deliverAddressData.getUserPhone());
            if (!useAddressBook) {
                sendData.setPhoneIcon(58908);
            }
        } else {
            sendData.setMobile("-");
        }
        Map<String, Object> sendRawData = new HashMap<>(3);
        Map<String, Object> pageMap = new HashMap<>(2);
        pageMap.put("pageNo", "1");
        pageMap.put("pageSize", "9999");
        Boolean sendHaveEmpty = false;
        if (StringUtils.hasLength(deliverAddressData.getCompleteAddress())) {
            sendRawData.put("complete_address", deliverAddressData.getCompleteAddress());
        } else {
            sendHaveEmpty = true;
        }
        if (StringUtils.hasLength(deliverAddressData.getUserPhone())) {
            sendRawData.put("user_phone", deliverAddressData.getUserPhone());
        } else {
            sendHaveEmpty = true;
        }
        if (StringUtils.hasLength(deliverAddressData.getUserName())) {
            sendRawData.put("user_name", deliverAddressData.getUserName());
        } else {
            sendHaveEmpty = true;
        }
        if (sendHaveEmpty) {
            sendData.setPlaceholderAddress(LocaleUtil.getMobileTextByKey(locale, "请填写详细地址、联系人、联系电话"));
            sendData.setPlaceholderName(LocaleUtil.getMobileTextByKey(locale, "发货信息"));
        }
        if (useAddressBook) {
            sendData.setModifiyAddress(Button.createModifiyAddress(UUIDUtil.getUuid(), sendRawData, locale, ""));
            sendData.setAddressBook(Button.createAddressBook(UUIDUtil.getUuid(), pageMap, locale));
        } else {
            sendData.setMapIcon(58948);
        }


        sendData.setType(LogisticsEnum.SEND.getValue());
        sendData.setIconName(LocaleUtil.getMobileTextByKey(locale, "发"));
        sendData.setUseAddressBook(useAddressBook);
        logisticsDataList.add(sendData);

        LogisticsData receiveData = new LogisticsData();
        ZtbUserAddress receiveAddressData = JsonUtil.objectToJavaObject(receiptAddress, ZtbUserAddress.class);
        receiveData.setCompleteAddress(receiveAddressData.getCompleteAddress());
        receiveData.setName(receiveAddressData.getUserName());
        if (StringUtils.hasLength(receiveAddressData.getUserPhone())) {
            receiveData.setMobile(receiveAddressData.getUserPhone());
            if (!useAddressBook) {
                receiveData.setPhoneIcon(58908);
            }
        } else {
            receiveData.setMobile("-");
        }

        Map<String, Object> receiveRawData = new HashMap<>(3);
        Boolean receiveHaveEmpty = false;
        if (StringUtils.hasLength(receiveAddressData.getCompleteAddress())) {
            receiveRawData.put("complete_address", receiveAddressData.getCompleteAddress());
        } else {
            receiveHaveEmpty = true;
        }
        if (StringUtils.hasLength(receiveAddressData.getUserPhone())) {
            receiveRawData.put("user_phone", receiveAddressData.getUserPhone());
        } else {
            receiveHaveEmpty = true;
        }
        if (StringUtils.hasLength(receiveAddressData.getUserName())) {
            receiveRawData.put("user_name", receiveAddressData.getUserName());
        } else {
            receiveHaveEmpty = true;
        }
        if (receiveHaveEmpty) {
            receiveData.setPlaceholderAddress(LocaleUtil.getMobileTextByKey(locale, "请填写详细地址、联系人、联系电话"));
            receiveData.setPlaceholderName(LocaleUtil.getMobileTextByKey(locale, "收货信息"));
        }
        if (useAddressBook) {
            receiveData.setModifiyAddress(Button.createModifiyAddress(UUIDUtil.getUuid(), receiveRawData, locale, ""));
            receiveData.setAddressBook(Button.createAddressBook(UUIDUtil.getUuid(), pageMap, locale));
        } else {
            receiveData.setMapIcon(58948);
        }


        receiveData.setType(LogisticsEnum.RECEIVER.getValue());
        receiveData.setIconName(LocaleUtil.getMobileTextByKey(locale, "收"));
        receiveData.setUseAddressBook(useAddressBook);

        logisticsDataList.add(receiveData);
        logistics.setRequired(true);

        return logistics;
    }

    public static Logistics createEmpty(LocaleService localeService, String locale, Boolean useAddressBook) {
        Logistics logistics = new Logistics();
        List<LogisticsData> logisticsDataList = new ArrayList<>(2);
        logistics.setLogisticsDataList(logisticsDataList);
        logistics.setSchema(Logistics.COMPONENT_TYPE);
        logistics.setHidden(false);
        logistics.setEnable(true);

        LogisticsData sendData = new LogisticsData();
        sendData.setPlaceholderName(localeService.getLanguageValue(locale, "发货信息"));
        sendData.setPlaceholderAddress(localeService.getLanguageValue(locale, "请填写详细地址、联系人、联系电话"));
        Map<String, Object> pageMap = new HashMap<>(2);
        pageMap.put("pageNo", "1");
        pageMap.put("pageSize", "9999");

        if (useAddressBook) {
            sendData.setModifiyAddress(Button.createModifiyAddress(UUIDUtil.getUuid(), Collections.emptyMap(), locale, ""));
            sendData.setAddressBook(Button.createAddressBook(UUIDUtil.getUuid(), pageMap, locale));
        } else {
            sendData.setMapIcon(58948);
        }


        sendData.setType(LogisticsEnum.SEND.getValue());
        sendData.setIconName(LocaleUtil.getMobileTextByKey(locale, "发"));
        sendData.setUseAddressBook(useAddressBook);
        logisticsDataList.add(sendData);

        LogisticsData receiveData = new LogisticsData();
        receiveData.setPlaceholderAddress(LocaleUtil.getMobileTextByKey(locale, "请填写详细地址、联系人、联系电话"));
        receiveData.setPlaceholderName(LocaleUtil.getMobileTextByKey(locale, "收货信息"));
        if (useAddressBook) {
            receiveData.setModifiyAddress(Button.createModifiyAddress(UUIDUtil.getUuid(), Collections.emptyMap(), locale, ""));
            receiveData.setAddressBook(Button.createAddressBook(UUIDUtil.getUuid(), pageMap, locale));
        } else {
            receiveData.setMapIcon(58948);
        }


        receiveData.setType(LogisticsEnum.RECEIVER.getValue());
        receiveData.setIconName(LocaleUtil.getMobileTextByKey(locale, "收"));
        receiveData.setUseAddressBook(useAddressBook);

        logisticsDataList.add(receiveData);
        logistics.setRequired(true);

        return logistics;
    }

    @Override
    public String returnComponentType() {
        return Logistics.COMPONENT_TYPE;
    }

    @Override
    public void applyEditable(Boolean enable) {
        this.enable = enable;
    }

    @Override
    public void applyHidden(Boolean hidden) {
        this.hidden = hidden;
    }
}




