package com.digiwin.mobile.mobileuibot.core.component.logistics;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.StringUtils;

import java.io.Serializable;

/**
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class LogisticsData implements Serializable {
    private static final long serialVersionUID = -2242925532473848068L;

    /**
     * 最左侧的icon图标(收、发的字)
     */
    private String iconName;
    /**
     * 姓名（收货人姓名，发货人姓名，物流信息等）
     */
    private String name;
    @JSONField(name = "user_name")
    private String userName;
    /**
     * 手机号
     */
    private String mobile;
    @JSONField(name = "user_phone")
    private String userPhone;
    /**
     * 类型 0: 中间节点;1：发货人; 2：收货人
     */
    private Integer type;
    /**
     * 省
     */
    private String province;
    /**
     * 市
     */
    private String city;
    /**
     * 区
     */
    private String area;
    /**
     * 街道
     */
    private String street;
    /**
     * 地址(小区名称+门牌号)
     */
    private String address;
    /**
     * 完整地址（省市区街道小区门牌号）
     */
    private String completeAddress;
    /**
     * 打电话ICON（不填默认不展示）
     */
    private Integer phoneIcon;
    /**
     * 地图icon(不填默认不展示)
     */
    private Integer mapIcon;
    /**
     * 是否展示地址簿(默认不展示)
     */
    private Boolean useAddressBook = false;
    /**
     * 地址簿按钮
     */
    private Button addressBook;
    /**
     * 条目按钮--修改或者新增地址
     */
    private Button modifiyAddress;
    /**
     * 提示语(当联系人、电话、地址为空时会提示)
     */
    private String placeholderAddress;
    /**
     * 提示语（发货信息或者收货信息）
     */
    private String placeholderName;
    /**
     * 地址簿ID
     */
    @JSONField(name = "address_id")
    private String addressId;
    private String id;

    public String getAddressId() {
        return addressId;
    }

    public void setAddressId(String addressId) {
        if (StringUtils.hasLength(addressId)) {
            this.id = addressId;
        }
        this.addressId = addressId;
    }
}
