package com.digiwin.mobile.mobileuibot.core.component.logistics;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;

/**
 * @author zhangjj
 * @date 2021/11/24 0024 14:46
 */
@Component("logisticsParamAnalyzer")
public class LogisticsParamAnalyzer implements ComponentParamAnalyzer<Logistics, List> {

    private static final Logger logger = LoggerFactory.getLogger(LogisticsParamAnalyzer.class);

    @Override
    public String getComponentType() {
        return Logistics.COMPONENT_TYPE;
    }

    @Override
    public Class getSubmitParamType() {
        return Logistics.class;
    }

    @Override
    public List analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof List)) {
            logger.debug("submitParam is not instanceof Field component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return Collections.emptyList();
        }

        List<LogisticsData> dataList = (List<LogisticsData>) submitParam;
        if (dataList == null || dataList.size() == 0) {
            return Collections.emptyList();
        } else {
            return dataList;
        }
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object... args) {

    }
}
