package com.digiwin.mobile.mobileuibot.core.component.mapaddress;

import cn.hutool.core.util.StrUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.HashMap;
import java.util.Map;

/**
 * @author wuyang
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MapAddress extends BaseMobileComponent {
    private static final long serialVersionUID = -8184903183383750876L;
    public static final String COMPONENT_TYPE = "MAP_ADDRESS";

    private String title;
    private String schema;
    private String startAddress;
    private String endAddress;
    private Map<String, Object> rawData;

    public static MapAddress create(String schema, DigiwinTransportResponse transportMainInfo, LocaleService localeService, String locale) {
        MapAddress mapAddress = new MapAddress();
        mapAddress.setSchema(schema);
        mapAddress.setStartAddress(transportMainInfo.getDeliveryAddress());
        mapAddress.setEndAddress(transportMainInfo.getReceiptAddress());
        Map<String, Object> rawData = new HashMap<>();
        rawData.put("showPrompt", false);
        //判断是否显示提示框
        if (StrUtil.equals(transportMainInfo.getElectronicFenceStatus(), "1")){
            if (StrUtil.equals(transportMainInfo.getArrivalStatus(), "0")){
                rawData.put("showPrompt", true);
                rawData.put("name", localeService.getLanguageValue(locale, "即将到达,点击查看入厂指引>>"));
                rawData.put("currentLongitude", transportMainInfo.getCurrentLongitude());
                rawData.put("currentLatitude", transportMainInfo.getCurrentLatitude());
                Action action = new Action();
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_TRANSPORT_FACTORY_GUIDE.toString());
                action.setJumpPageTitle(localeService.getLanguageValue(locale, "入厂指引"));
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                Map<String, Object> detailRawData = new HashMap<>(1);
                detailRawData.put("transportNo", transportMainInfo.getTransportNo());
                action.setRawData(detailRawData);
                rawData.put("action", action);
            } else if(StrUtil.equals(transportMainInfo.getArrivalStatus(), "1")){
                rawData.put("showPrompt", true);
                rawData.put("name", localeService.getLanguageValue(locale, "已到达,点击查看入厂凭证>>"));
                rawData.put("currentLongitude", transportMainInfo.getCurrentLongitude());
                rawData.put("currentLatitude", transportMainInfo.getCurrentLatitude());
                Action action = new Action();
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_TRANSPORT_FACTORY_VOUCHER.toString());
                action.setJumpPageTitle(localeService.getLanguageValue(locale, "入厂凭证"));
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE_AND_SUBMIT.getValue());
                Map<String, Object> detailRawData = new HashMap<>(1);
                detailRawData.put("transportNo", transportMainInfo.getTransportNo());
                action.setRawData(detailRawData);
                rawData.put("action", action);
            }
        }
        mapAddress.setRawData(rawData);
        return mapAddress;
    }


    @Override
    public String returnComponentType() {
        return MapAddress.COMPONENT_TYPE;
    }
}
