package com.digiwin.mobile.mobileuibot.core.component.milestone;

import com.digiwin.mobile.mobileuibot.task.model.MobileProcessStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：里程碑节点</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MilestoneNode.java
 * @Author: wangjwc
 * @Date: created at 2025/3/13 11:51
 */
@Data
public class MilestoneNode implements Serializable {
    private static final long serialVersionUID = -3795444528864921987L;
    /**
     * 节点名称
     */
    private String name;
    /**
     * 节点状态，0：未完成  1：正常进行中 2：已完成
     * @see MobileProcessStatusEnum
     */
    private Integer status;
    /**
     * 当前节点是否选中
     */
    private Boolean defaultSelect = false;
    /**
     * 节点下内容列表
     */
    private List<MilestoneNodeContent> contentList;
}
