package com.digiwin.mobile.mobileuibot.core.component.navbar.index;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.AppInfo;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentPerson;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.search.UniSearch;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.model.LaunchableProject;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：首页导航栏组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: IndexNavBar
 * @Author: Zaregoto
 * @Date: 2022/1/23 18:21
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class IndexNavBar extends BaseMobileComponent implements Serializable {
    private static final long serialVersionUID = 7492504878094457523L;
    public static final String COMPONENT_TYPE = "INDEX_NAVBAR";

    @Override
    public String returnComponentType() {
        return IndexNavBar.COMPONENT_TYPE;
    }

    private List<BottomButtonDigiwinAthena> customButtonList;
    private BaseMobileComponentPerson person;
    private List<IndexNavBarPersonState> personState;
    private Boolean scannerEnable;
    private String welcomeText;
    /**
     * 提示文字的标题
     */
    private String hintTitle;
    /**
     * 提示文字的主体
     */
    private String hintBody;
    private Boolean placeholderEnable;

    /**
     * 聚合搜索组件
     * 2022年6月迭代15结束后，为演示改造
     */
    private UniSearch uniSearch;

    /**
     * 创建项目-快捷按钮
     */
    private BottomButtonDigiwinAthena shortcutButton;

    /**
     * 通讯簿
     */
    private BottomButtonDigiwinAthena addressbBookButton;

    /**
     * 初始化设置
     * 1、多语言设置
     * 2、按钮请求地址设置
     *
     * @param locale
     */
    public void initSetting(String locale, AppInfo appInfo) {
        if (null != this.getCustomButtonList()) {
            for (BottomButtonDigiwinAthena buttonDigiwinAthena : customButtonList) {
                if (buttonDigiwinAthena.getName() != null) {
                    buttonDigiwinAthena.setName(
                            LocaleUtil.getMobileTextByDatabaseKey(locale, buttonDigiwinAthena.getName()));
                }
                this.setRequestUrl(buttonDigiwinAthena);
                List<BottomButtonDigiwinAthena> children = buttonDigiwinAthena.getChildren();
                if (children != null && children.size() > 0) {
                    for (BottomButtonDigiwinAthena button : children) {
                        if (button.getName() != null) {
                            button.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, button.getName()));
                        }
                        if (button.getSubName() != null) {
                            button.setSubName(LocaleUtil.getMobileTextByDatabaseKey(locale, button.getSubName()));
                        }
                        if (button.getAction() != null) {
                            Action action = button.getAction();
                            if (action.getJumpPageTitle() != null) {
                                action.setJumpPageTitle(LocaleUtil.getMobileTextByDatabaseKey(locale, action.getJumpPageTitle()));
                            }
                            if (StringUtils.hasLength(action.getToastMsg())) {
                                action.setToastMsg(LocaleUtil.getMobileTextByDatabaseKey(locale, action.getToastMsg()));
                            }
                        }
                        this.setRequestUrl(button);
                    }
                }
            }
        }
        if (null != this.getPerson()) {
            if (StringUtils.hasLength(person.getName())) {
                person.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, person.getName()));
            }
        }
        if (null != this.getPersonState()) {
            for (IndexNavBarPersonState indexNavBarPersonState : this.getPersonState()) {
                if (null != indexNavBarPersonState.getText()) {
                    indexNavBarPersonState.setText(LocaleUtil.getMobileTextByDatabaseKey(locale, indexNavBarPersonState.getText()));
                }
            }
        }
        Boolean usePlaceholder = false;
        if (appInfo != null && appInfo.getAppVersion() != null) {
            String[] verson = appInfo.getAppVersion().split("\\.");
            if (verson.length > 0) {
                try {
                    usePlaceholder = compareVersion(appInfo.getAppVersion(), "1.7.6") >= 0;
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        //开启提示且要版本号大于1.7.6
        if (this.placeholderEnable != null && this.placeholderEnable && usePlaceholder) {
            if (null != this.getHintTitle()) {
                this.hintTitle = LocaleUtil.getMobileTextByDatabaseKey(locale, this.hintTitle);
                this.hintBody = LocaleUtil.getMobileTextByDatabaseKey(locale, this.hintBody);
            } else {
                this.hintTitle = "";
                this.hintBody = "";
            }
        } else {
            this.hintTitle = "";
            this.hintBody = "";
        }

        if (null != this.getUniSearch()) {
            this.getUniSearch().initSetting(locale);
        }
    }

    /**
     * version1 > version2，则返回正数
     * version1 = version2，则返回0
     * version1 < version2，则返回负数
     *
     * @param version1
     * @param version2
     * @return
     * @throws Exception
     */
    private static int compareVersion(String version1, String version2) throws Exception {
        if (!StringUtils.hasLength(version1) || !StringUtils.hasLength(version2)) {
            throw new Exception("compareVersion error:illegal params.");
        }
        String[] versionArray1 = version1.split("\\.");
        String[] versionArray2 = version2.split("\\.");
        int idx = 0;
        int minLength = Math.min(versionArray1.length, versionArray2.length);
        int diff = 0;
        while (idx < minLength
                && (diff = versionArray1[idx].length() - versionArray2[idx].length()) == 0
                && (diff = versionArray1[idx].compareTo(versionArray2[idx])) == 0) {

            ++idx;

        }
        diff = (diff != 0) ? diff : versionArray1.length - versionArray2.length;
        return diff;
    }

    public static boolean notOptimizedRawData(AppInfo appInfo) {
        boolean usePlaceholder = false;
        if (appInfo != null && appInfo.getAppVersion() != null) {
            String[] verson = appInfo.getAppVersion().split("\\.");
            if (verson.length > 0) {
                try {
                    usePlaceholder = compareVersion(appInfo.getAppVersion(), "1.50.0") < 0;
                } catch (Exception ignored) {
                }
            }
        }
        return usePlaceholder;
    }

    private void setRequestUrl(BottomButtonDigiwinAthena button) {
        Action action = button.getAction();
        if (action == null || action.getRequestUrl() == null || action.getRequestUrl().length() == 0) {
            return;
        }
        action.setRequestUrl(AppContext.getBaseUrl() + action.getRequestUrl());
    }

    /**
     * 快捷创建项目button
     * 若可发起项目数>1，打开原来的项目发起左滑页；
     * 若=0，提示用户无可发起项目（具体交互需静静确认）；
     * 若=1，直接进入该项目发起的页面
     *
     * @param apiRequest
     * @param projectService
     * @param localeService
     */
    public void initShortcutButton(ApiRequest apiRequest, ProjectService projectService, LocaleService localeService) {
        if (CollectionUtils.isEmpty(this.customButtonList)) {
            return;
        }
        shortcutButton = new BottomButtonDigiwinAthena();
        shortcutButton.setIconData(customButtonList.get(0).getIconData());

        // 获取可发起项目（仅移动目前支持的项目）
        List<LaunchableProject> launchableProjectList = projectService
                .getLaunchableProjectList(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        // 若=0，提示用户无可发起项目
        if (CollectionUtils.isEmpty(launchableProjectList)) {
            Action action = new Action();
            action.setToastMsg(localeService.getLanguageValue(apiRequest.getLocale(), "无可发起的项目！"));
            action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
            shortcutButton.setAction(action);
            return;
        }
        // 若=1，直接进入该项目发起的页面
        if (launchableProjectList.size() == 1) {
            LaunchableProject project = launchableProjectList.get(0);
            Action action = new Action();
            action.setDataId(project.getCreateSuffix());

            // 发起项目设计器跳转需要的信息
            if (BooleanUtils.isTrue(project.getIsDesigner())) {
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CREATE_V2_PAGE.toString());
                action.setJumpPageTitle(project.getName());
                Map<String, Object> rawData = new HashMap<>(2);
                rawData.put("project_introduce", project.getDesc());
                rawData.put("project_name", project.getName());
                rawData.put("dataId", project.getCreateSuffix());
                action.setRawData(rawData);
            } else {
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE.name());
                action.setJumpPageTitle(project.getName());
            }
            shortcutButton.setAction(action);
            return;
        }

        // 可发起项目数>1，打开原来的项目发起左滑页
        List<BottomButtonDigiwinAthena> children = customButtonList.get(0).getChildren();
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        shortcutButton.setAction(children.get(0).getAction());
    }
}
