package com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * <p>功能描述：基础PageDesc构造器，统一了相同的方法和变量</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BasePageDescBuilder
 * @Author: Zaregoto
 * @Date: 2021/6/25 11:43
 */
public abstract class BasePageDescBuilder implements PageDescBuilder {

    private static final Logger logger = LoggerFactory.getLogger(BasePageDescBuilder.class);

    /**
     * 本组件关联的PC端layout清单
     */
    private final List<String> pcLayoutTypeList;

    protected List<String> getPcLayoutTypeList() {
        return pcLayoutTypeList;
    }

    public BasePageDescBuilder() {
        // 初始化需要解析的pc端layout类型
        this.pcLayoutTypeList = new ArrayList<>(2);
        this.pcLayoutTypeList.add("ACTIVITY_TITLE");
        this.pcLayoutTypeList.add("APPROVAL_DESCRIPTION");
    }

    /**
     * 任务逾时天数 icon数据
     *
     * @return
     */
    protected Integer getOverdueDateIconData() {
        return 0xe66e;
    }

    /**
     * 项目名称（带时距） icon数据
     *
     * @return
     */
    protected Integer getProjectNameOnCardIconData() {
        return 0xe673;
    }

    /**
     * 项目来源 icon数据
     *
     * @return
     */
    protected Integer getProjectSourceInfoIconData() {
        return 0xe675;
    }

    /**
     * 项目发起方信息 icon数据
     *
     * @return
     */
    protected Integer getProjectInitiatorInfoIconData() {
        return 0xe68d;
    }

    /**
     * 项目时距 icon数据
     *
     * @return
     */
    protected Integer getProjectTimeDistanceIconData() {
        return 0xe673;
    }

    /**
     * 项目编号 icon数据
     *
     * @return
     */
    protected Integer getProjectNoIconData() {
        return 0xe78a;
    }

    /**
     * 项目名称 icon数据
     *
     * @return
     */
    protected Integer getProjectNameIconData() {
        return 0xe675;
    }

    /**
     * 项目负责人 icon数据
     *
     * @return
     */
    protected Integer getProjectLeaderNameIconData() {
        return 0xe789;
    }

    /**
     * 从pc的数据中，提取要构造组件的数据
     *
     * @param pcUiBotModel
     * @return 一个数据的清单。每个数据对应一个pcLayoutList中的元素，按固定顺序返回
     */
    protected List<PageDescBuildData> extractBuildData(UiBotModel pcUiBotModel) {
        List<PageDescBuildData> buildData = new ArrayList<>(this.getPcLayoutTypeList().size());
        for (String pcLayoutType : this.pcLayoutTypeList) {
            Optional<UiBotLayout> optLayout = pcUiBotModel.getLayout()
                    .stream().filter(layout -> layout.getType() != null
                            && layout.getType().equalsIgnoreCase(pcLayoutType))
                    .findFirst();
            optLayout.ifPresent(uiBotLayout -> {
                String schema = uiBotLayout.getSchema();
                Map<String, Object> data = (Map<String, Object>) pcUiBotModel.getPageData().get(schema);
                if (null != uiBotLayout.getGroup()) {
                    buildData.add(PageDescBuildData.create(pcLayoutType, data, uiBotLayout.getGroup()));
                } else {
                    buildData.add(PageDescBuildData.create(pcLayoutType, data));
                }
            });
        }

        return buildData;
    }

    /**
     * 将PC UIBot中对应APPROVAL_DESCRIPTION的字段展示在PageDesc对象中
     *
     * @param pageDesc  PageDesc对象实例
     * @param buildData 构造数据。
     * @see BasePageDescBuilder#extractBuildData
     */
    protected void addDescriptionalDataToPageDesc(PageDesc pageDesc, PageDescBuildData buildData) {
        for (UiBotLayout uiBotFieldLayout : buildData.getFieldLayoutList()) {
            String fieldSchema = uiBotFieldLayout.getSchema();
            if ("LABEL".equalsIgnoreCase(uiBotFieldLayout.getType()) && buildData.getData().containsKey(fieldSchema)) {
                String title = uiBotFieldLayout.getTitle();
                if (!StringUtils.hasLength(title)) {
                    title = uiBotFieldLayout.getHeaderName();
                }
                String value = String.valueOf(buildData.getData().get(fieldSchema));
                StringJoiner sj = new StringJoiner(":");
                sj.add(title);
                sj.add(StringUtils.hasLength(value) ? value : "-");
                // 和Athena绑定写死的字段和icon的设置
                Integer iconData = -1;
                if ("project_no".equalsIgnoreCase(fieldSchema)) {
                    iconData = this.getProjectNoIconData();
                }
                if ("project_name".equalsIgnoreCase(fieldSchema)) {
                    iconData = this.getProjectNameIconData();
                }
                if ("project_leader_name".equalsIgnoreCase(fieldSchema)) {
                    iconData = this.getProjectLeaderNameIconData();
                }
                pageDesc.addContent(iconData, sj.toString(), PageDescContentTypeEnum.NORMAL.getValue());
            }
        }
    }

}
