package com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：移动端页面描述组件（点击标题右侧?按钮，底部弹窗出现）</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PageDesc
 * @Author: Zaregoto
 * @Date: 2021/5/19 20:41
 */
public class PageDesc extends BaseMobileComponent implements Serializable {
    private static final long serialVersionUID = -7744917082340162383L;
    public static final String COMPONENT_TYPE = "PAGE_DESC";

    private String title;
    private List<PageDescContent> content;
    private List<LabelValue> labelValueList;

    public PageDesc() {
        this.content = new ArrayList<>(5);
    }

    public PageDesc(String title) {
        this();
        this.title = title;
    }

    public static PageDesc createEmpty() {
        return new PageDesc();
    }

    public PageDesc addContent(Integer iconData, String text, Integer pageDescContentType) {
        if (null == text || text.trim().length() == 0) {
            return this;
        }
        this.content.add(new PageDescContent(iconData, text, pageDescContentType));
        return this;
    }

    public PageDesc addContentWithoutIcon(String text, Integer pageDescContentType) {
        if (null == text || text.trim().length() == 0) {
            return this;
        }
        this.content.add(new PageDescContent(text, pageDescContentType));
        return this;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<PageDescContent> getContent() {
        return content;
    }

    public void setContent(List<PageDescContent> content) {
        this.content = content;
    }

    public List<LabelValue> getLabelValueList() {
        return labelValueList;
    }

    public void setLabelValueList(List<LabelValue> labelValueList) {
        this.labelValueList = labelValueList;
    }

    @Override
    public String returnComponentType() {
        return PageDesc.COMPONENT_TYPE;
    }

    public static class LabelValue implements Serializable {
        private static final long serialVersionUID = -3515740499770555529L;
        private String label;
        private String value;

        public LabelValue() {
        }

        public LabelValue(String label, String value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
