package com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.project.common.ProjectStringUtil;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * <p>功能描述：签核型任务的PageDesc控件构造</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PageDescBizApprovalBuilder
 * @Author: Zaregoto
 * @Date: 2021/5/19 22:45
 */
@Component("pageDescBizApprovalBuilder")
public class PageDescBizApprovalBuilder extends BasePageDescBuilder {

    private static final Logger logger = LoggerFactory.getLogger(PageDescBizApprovalBuilder.class);

    @Override
    public String getBuilderDetailType() {
        return TaskStringUtil.TASK_TYPE_BIZ_APPROVAL;
    }

    @Override
    public PageDesc build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                          Class<PageDesc> clazz, Object... args) {
        String locale = apiRequest.getLocale();

        List<PageDescBuildData> buildDataList = super.extractBuildData(pcUiBotModel);
        PageDesc pageDesc = PageDesc.createEmpty();
        for (PageDescBuildData buildData : buildDataList) {
            if (null == buildData.getData()) {
                continue;
            }
            boolean isDescriptionData = null != buildData.getFieldLayoutList();
            if (!isDescriptionData) {
                // 对方接口的taskName是项目名称，name是任务名称。是历史原因
                String title = (String) buildData.getData().get("name");
                String overdueDate = (String) buildData.getData().get("overdueDate");
                String projectName = ProjectStringUtil.getProjectNameOnCard(
                        locale,
                        (String) buildData.getData().get("taskStartTime"), (String) buildData.getData().get("taskEndTime"),
                        (String) buildData.getData().get("taskName"), false);
                String overduePrefix = LocaleUtil.getMobileTextByKey(locale, "已逾期") + "%s";
                DigiwinAtmcBacklogDetail backlogDetail = (DigiwinAtmcBacklogDetail) args[0];

                pageDesc.setTitle(title);
                if (StringUtils.hasLength(overdueDate)) {
                    pageDesc.addContent(super.getOverdueDateIconData(), String.format(overduePrefix, overdueDate), PageDescContentTypeEnum.ABNORMAL.getValue());
                }
                if (StringUtils.hasLength(projectName)) {
                    pageDesc.addContent(super.getProjectNameOnCardIconData(), projectName, PageDescContentTypeEnum.NORMAL.getValue());
                }
            } else {
                super.addDescriptionalDataToPageDesc(pageDesc, buildData);
            }
        }
        return pageDesc;
    }

}
