package com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：移动端页面描述组件生成时使用的构造数据</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PageDescBuildData
 * @Author: Zaregoto
 * @Date: 2022/2/15 23:05
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PageDescBuildData implements Serializable {
    private static final long serialVersionUID = -470094842979172521L;

    private String pcLayoutType;
    private Map<String, Object> data;
    // 不一定有值，可以为空
    private List<UiBotLayout> fieldLayoutList;


    public static PageDescBuildData create(String pcLayoutType, Map<String, Object> data) {
        PageDescBuildData pageDescBuildData = new PageDescBuildData();
        pageDescBuildData.setPcLayoutType(pcLayoutType);
        pageDescBuildData.setData(data);

        return pageDescBuildData;
    }


    public static PageDescBuildData create(String pcLayoutType, Map<String, Object> data,
                                           List<UiBotLayout> uiBotFieldLayoutList) {
        PageDescBuildData pageDescBuildData = new PageDescBuildData();
        pageDescBuildData.setPcLayoutType(pcLayoutType);
        pageDescBuildData.setData(data);
        pageDescBuildData.setFieldLayoutList(uiBotFieldLayoutList);

        return pageDescBuildData;
    }

}
