package com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;

/**
 * <p>功能描述：移动端页面描述组件（点击标题右侧?按钮，底部弹窗出现）创建工厂</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PageDescBuilder
 * @Author: Zaregoto
 * @Date: 2021/5/19 21:00
 */
public interface PageDescBuilder extends MobileComponentBuilder<PageDesc> {

    @Override default String getMobileComponentType() {
        return PageDesc.COMPONENT_TYPE;
    }

    @Override default PageDesc build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
        Class<PageDesc> clazz, Object... args) {
        return null;
    }

    /**
     * 构造空页面标题AppBar
     * @return
     */
    default PageDesc buildEmpty() {
        return PageDesc.createEmpty();
    }

    /**
     * 获取构造器的详细类型。目前会因不同Athena任务类型，或不同项目类型来区分；不同类型的构造器按需求有不同逻辑
     * @return
     */
    String getBuilderDetailType();
}
