package com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PageDescBuildStrategy
 * @Author: Zaregoto
 * @Date: 2021/6/25 13:01
 */
@Component("pageDescBuilderFactory")
public class PageDescBuilderFactory implements InitializingBean, ApplicationContextAware {

    private static final Map<String, PageDescBuilder> PAGEDESC_BUILDER_MAP = new HashMap<>();

    private ApplicationContext appContext;

    public PageDescBuilder get(String key) {
        return PAGEDESC_BUILDER_MAP.get(key);
    }

    @Override public void afterPropertiesSet() throws Exception {
        // 将 Spring 容器中所有的 PageDescBuilder 注册到 PAGEDESC_BUILDER_MAP
        this.appContext.getBeansOfType(PageDescBuilder.class).values().forEach(
            strategy -> PAGEDESC_BUILDER_MAP.put(strategy.getBuilderDetailType(), strategy));
    }

    @Override public void setApplicationContext(ApplicationContext applicationContext)
        throws BeansException {
        this.appContext = applicationContext;
    }
}
