package com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc;

import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinReassignReport;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PageDescContent
 * @Author: Zaregoto
 * @Date: 2021/5/19 20:59
 */
@Data
public class PageDescContent extends BaseMobileComponent implements Serializable {
    private static final long serialVersionUID = 8344161027726171364L;
    public static final String COMPONENT_TYPE = "PAGE_DESC_CONTENT";

    private Integer iconData;
    private String text;
    private Integer type;
    private Action action;

    public PageDescContent() {
    }

    public PageDescContent(Integer iconData, String text, Integer type) {
        if (null == iconData || iconData <= 0) {
            this.iconData = 0xe670;
        } else {
            this.iconData = iconData;
        }
        if (null == text || text.trim().length() == 0) {
            this.text = "No Data";
        } else {
            this.text = text;
        }
        if (null == type) {
            this.type = PageDescContentTypeEnum.NORMAL.getValue();
        } else {
            this.type = type;
        }
    }

    public PageDescContent(String text, Integer type) {
        if (StringUtil.isEmpty(text)) {
            this.text = "No Data";
        } else {
            this.text = text;
        }
        if (Objects.isNull(type)) {
            this.type = PageDescContentTypeEnum.NORMAL.getValue();
        } else {
            this.type = type;
        }
    }

    public static PageDescContent buildReassignReport(String locale, List<DigiwinReassignReport> reassignReportList) {
        PageDescContent pageDescContent = new PageDescContent();
        pageDescContent.setText(String.format(
                LocaleUtil.getMobileTextByKey(locale, "由转派"),
                reassignReportList.get(0).getOldPerformerName()));
        pageDescContent.setAction(Action.createReassignReportAction(locale,
                reassignReportList));
        pageDescContent.setIconData(0xe670);
        pageDescContent.setType(PageDescContentTypeEnum.NORMAL.getValue());
        return pageDescContent;
    }

    @Override
    public String returnComponentType() {
        return PageDescContent.COMPONENT_TYPE;
    }
}
