package com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.project.common.ProjectStringUtil;
import com.digiwin.mobile.mobileuibot.project.common.ProjectTypeUtil;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectInfo;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPanel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/**
 * <p>功能描述：项目中控台型项目的PageDesc控件构造</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PageDescProjectCCBuilder
 * @Author: Zaregoto
 * @Date: 2021/7/5 17:29
 */
@Component("pageDescProjectCCBuilder")
public class PageDescProjectCCBuilder extends BasePageDescBuilder {

    private static final Logger logger = LoggerFactory.getLogger(PageDescProjectCCBuilder.class);

    @Override
    public String getBuilderDetailType() {
        return ProjectTypeUtil.PCC_OLD_PROJECT_TYPE;
    }

    @Override
    public PageDesc build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                          Class<PageDesc> clazz, Object... args) {
        String locale = apiRequest.getLocale();

        Assert.notNull(args, "args must not null");
        Assert.notEmpty(args, "args must have value");
        Assert.isInstanceOf(PccProjectInfo.class, args[0],
                "args[0] must be instance of DigiwinAtdmProjectInfo");
        Assert.isInstanceOf(DigiwinAtmcPanel.class, args[1],
                "args[1] must be instance of DigiwinAtmcPanel");
        // 项目中控台在Athena的PCUiBot数据的pageData中为空，直接使用args[0]传入的项目对象
        PccProjectInfo projectInfo = (PccProjectInfo) args[0];
        DigiwinAtmcPanel atmcPanel = (DigiwinAtmcPanel) args[1];

        String title = projectInfo.getProjectName();
        String projectTimeDistance = ProjectStringUtil.getProjectCCProjectDateDistanceString(
                locale, projectInfo);
        String projectSourceInfo = ProjectStringUtil.getProjectSourceInfoString(locale, atmcPanel);
        String projectInitiatorInfo = ProjectStringUtil.getProjectInitiatorInfoString(locale, atmcPanel);

        PageDesc pageDesc = new PageDesc(title);
        if (StringUtils.hasLength(projectTimeDistance)) {
            pageDesc.addContent(super.getProjectTimeDistanceIconData(), projectTimeDistance, PageDescContentTypeEnum.NORMAL.getValue());
        }
        if (StringUtils.hasLength(projectSourceInfo)) {
            pageDesc.addContent(super.getProjectSourceInfoIconData(), projectSourceInfo, PageDescContentTypeEnum.NORMAL.getValue());
        }
        if (StringUtils.hasLength(projectInitiatorInfo)) {
            pageDesc.addContent(super.getProjectInitiatorInfoIconData(), projectInitiatorInfo, PageDescContentTypeEnum.NORMAL.getValue());
        }
        return pageDesc;
    }
}