package com.digiwin.mobile.mobileuibot.core.component.news;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import lombok.Data;

/****
 * 公告
 */
@Data
public class News extends BaseMobileComponent {

    public static final String COMPONENT_TYPE = "NOTICE";

    /**
     * 样式 0无图 1有图
     */
    private Integer style;

    /**
     * 标题
     */
    private String title;

    /**
     * 是否显示发布时间
     */
    private Integer showPublishTime;

    /**
     * 是否显示阅读次数
     */
    private Integer showReadCount;

    /**
     * 一级公告类型id，0表示全部公告
     */
    private Integer newsTypeId;

    /**
     * 二级公告类型id
     */
    private Integer childrenNewsTypeId;
    /**
     * 公告显示数量
     */
    private Integer newsCount;

    /**
     * 是否显示点赞数量（0：否（默认）、1：是）
     */
    private Integer newsLikeCountFlag;

    @Override
    public String returnComponentType() {
        return COMPONENT_TYPE;
    }


}
