package com.digiwin.mobile.mobileuibot.core.component.picture;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 *V2门户图片组件
 */
@Data
public class PictureComponent extends BaseMobileComponent implements Serializable {

    public static final String COMPONENT_TYPE = "PICTURE_TILE";
    private static final long serialVersionUID = 6491971829998038208L;

    /**
     *图片链接
     */
    private String picUrl;

    /**
     *热区
     */
    private List<PictureHotZone> area;

    @Override
    public String returnComponentType() {
        return PictureComponent.COMPONENT_TYPE;
    }
}
