package com.digiwin.mobile.mobileuibot.core.component.picture;

import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 *V2门户图片组件中的热区
 */
@Data
public class PictureHotZone implements Serializable {

    private static final long serialVersionUID = 6491971829998038208L;

    /**
     *热区位置信息，格式为[x1,y1,x2,y2]，
     * 数据类型均为数字，x1,y1为热区左上顶点坐标，
     * x2,y2为热区右下顶点坐标，以此来确认热区的位置和大小
     */
    private List<Double> position;

    /**
     * ActionEvent，移动端事件类
     */
    private Action action;

}
