package com.digiwin.mobile.mobileuibot.core.component.processnode;

import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;


/**
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MobileProcess implements Serializable {
    private static final long serialVersionUID = 3158139625984174384L;

    /**
     * 暂不使用
     */
    private Action action;
    /**
     * 节点数据
     */
    private UiBotModel data;
    /**
     * 当前节点是否选中
     */
    private Boolean defaultSelect = false;
    /**
     * 节点名称
     */
    private String name;
    private Map<String, Object> rawData;
    /**
     * 数据请求的url
     */
    private String requestUrl;

    /**
     * 底部按钮schema
     */
    private String bottomButtonSchema;

    /**
     * 节点状态 未完成 0  正常进行中 1   已完成  2
     */
    private Integer status;

    /**
     * 底部按钮
     */
    private BottomButtonList bottomButtonList;

    /**
     * 未处理数量（红色圆）
     */
    private Integer unHandleCount;

    private String dataId;
}
