package com.digiwin.mobile.mobileuibot.core.component.processnode;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class ProcessNode extends BaseMobileComponent implements Serializable {
    private static final long serialVersionUID = -4910751092978008743L;

    public static final String COMPONENT_TYPE = "PROCESS_NODE";

    /**
     * 选中节点的颜色
     */
    private String activeNodeColor = "#333333";
    /**
     * 分隔符的颜色
     */
    private String dividerColor = "#000000";
    /**
     * 节点的颜色
     */
    private String nodeColor = "#123123";
    /**
     * 切换的时候是否加载数据
     */
    private Boolean switchLoadData = true;

    private List<MobileProcess> processList = new ArrayList<>(3);

    public static ProcessNode create(UiBotModel uiBotModel, ProcessNode processNode, List<Map<String, Object>> opDatas,
                                     LocaleService localeService, String locale,
                                     DigiwinAtdmProxyService digiwinAtdmProxyService, ApiRequest apiRequest,
                                     Boolean hasButton, int processNo,
                                     DigiwinEspProxyService digiwinEspProxyService, String reportNo) {
        UiBotModel oldUibotModel = processNode.getProcessList().get(0).getData();
        int i = 0;
        for (Map<String, Object> opData : opDatas) {
            List<Map<String, Object>> saveOpdatas = new ArrayList<>(1);
            opData.put("report_no", reportNo);
            saveOpdatas.add(opData);
            digiwinEspProxyService.createTbdsTrialProductionReport(apiRequest.getIamUserToken(),
                    apiRequest.getTenantId(), locale, saveOpdatas);
            Map<String, Object> newCommonRawData = new HashMap<>(8);
            MobileProcess mobileProcess = new MobileProcess();
            mobileProcess.setName((String) opData.get("op_name"));
            if ("1".equals(opData.get("is_associate_project"))) {
                continue;
            }
            if (i == processNo) {
                mobileProcess.setDefaultSelect(true);
            }
            uiBotModel.buildCommonRawData(newCommonRawData, opData, uiBotModel);
            newCommonRawData.remove("trial_op_report_item_list");
            newCommonRawData.put("trial_op_report_item_list" + "_" + i, opData.get("trial_op_report_item_list"));
            newCommonRawData.put("nodeNo", i);
            i++;
            mobileProcess.setRawData(JsonUtil.objectToJavaObject(newCommonRawData, Map.class));
            UiBotModel newUiBotModel = JsonUtil.objectToJavaObject(oldUibotModel, UiBotModel.class);
            newUiBotModel.buildCommonRawData(newUiBotModel.getCommonRawData(), opData, newUiBotModel);
            mobileProcess.setData(buildProcessdata(newUiBotModel, opData, localeService, locale,
                    newCommonRawData, digiwinAtdmProxyService, apiRequest, hasButton));
            mobileProcess.setRequestUrl("/mobile/v1/proxy/get/processNode/data");
            processNode.getProcessList().add(mobileProcess);
        }
        processNode.getProcessList().remove(0);
        return processNode;
    }

    private static UiBotModel buildProcessdata(UiBotModel uiBotModel, Map<String, Object> opData,
                                               LocaleService localeService, String locale,
                                               Map<String, Object> commonRawData
            , DigiwinAtdmProxyService digiwinAtdmProxyService, ApiRequest apiRequest, Boolean hasButton) {
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout layout : uiBotModel.getLayout()) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case Card.COMPONENT_TYPE:
                    Card card = JsonUtil.objectToJavaObject(pageData.get(schema), Card.class);
                    Map<String, Object> cardRawData = new HashMap<>(1);
                    if ("base_message".equals(schema)) {
                        Card.create(card, opData, locale, localeService, false);
                    } else if ("trial_op_report_item".equals(schema)) {
                        List<Map<String, Object>> parameterDatas = (List<Map<String, Object>>) opData.get(schema);
                        if (CollectionUtils.isEmpty(parameterDatas)) {
                            pageData.put(schema, Card.createCardEmpty(card, locale, localeService));
                            continue;
                        }
                        Card.create(card, opData, locale, localeService, true);
                    } else if ("parameter_data".equals(schema)) {
                        List<Map<String, Object>> parameterDatas = (List<Map<String, Object>>) opData.get(schema);
                        if (CollectionUtils.isEmpty(parameterDatas)) {
                            pageData.put(schema, Card.createCardEmpty(card, locale, localeService));
                            continue;
                        }
                        cardRawData.put("data", parameterDatas);
                        Action action = new Action();
                        if (hasButton) {
                            action.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_NEXT_STEP.toString());
                            action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_MODIFY_PARAM.toString());
                            action.setJumpPageTitle(localeService.getLanguageValue(locale, "修改参数"));
                            action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                            cardRawData.put("nodeNo", commonRawData.get("nodeNo"));
                            action.setRawData(cardRawData);
                        }
                        Card.create(card, parameterDatas, locale, localeService, action);
                    }
                    pageData.put(schema, card);
                    break;
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = JsonUtil.objectToJavaObject(pageData.get(schema), CustomGroup.class);
                    customGroup.setName(localeService.getLanguageValue(locale, customGroup.getName()));
                    customGroup.setStyleType(CustomGroupStyleTypeEnum.TEXT_OUTSIDE_THE_TITLE_GROUP.getValue());
                    List<Map<String, Object>> itemList = (List<Map<String, Object>>) opData.get(schema);
                    if (CollectionUtils.isEmpty(itemList)) {
                        pageData.put(schema, CustomGroup.createEmptyGroup(locale, localeService.getLanguageValue(locale, layout.getLabel())));
                        continue;
                    }
                    customGroup.buildTbdsItemList(customGroup, locale, localeService, itemList,
                            commonRawData, digiwinAtdmProxyService, apiRequest, hasButton,
                            false, true);
                    pageData.put(schema, customGroup);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }


    @Override

    public String returnComponentType() {
        return ProcessNode.COMPONENT_TYPE;
    }
}
