package com.digiwin.mobile.mobileuibot.core.component.progress;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapperJsonDeserializer;
import com.digiwin.mobile.mobileuibot.core.component.DataSource;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.bpm.model.DigiwinBpmRedoTask;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonInfo;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachment;
import com.digiwin.mobile.mobileuibot.task.model.ApcTaskProgressStateEnum;
import com.digiwin.mobile.mobileuibot.task.model.TaskProgressPerson;
import com.digiwin.mobile.mobileuibot.task.model.TaskProgressStateEnum;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>功能描述：任务进度</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskProgress
 * @Author: Zaregoto
 * @Date: 2021/5/21 20:19
 */
@Data
public class TaskProgress extends BaseMobileComponent {
    private static final long serialVersionUID = 2506512381261018371L;

    public static final String COMPONENT_TYPE = "TASK_PROGRESS";

    @Override
    public String returnComponentType() {
        return TaskProgress.COMPONENT_TYPE;
    }

    private String id;
    private String name;

    private Card.DesignerRawCard.Content nameSetting;

    private Integer styleType = 1;
    private List<TaskProgressPerson> personList = new ArrayList<>(8);
    //状态：1、已完成；2、进行中；3、未开始
    private Integer state;

    /**
     * 设计态：状态
     */
    private String status;

    private Card.DesignerRawCard.Content statusSetting;

    /**
     * 设计器数据源映射类
     */
    private DataSource dataSource;

    private List<TaskProgress.TaskProgressContent> data;

    /**
     * 用于签核历程的节点(PCM在用)
     */
    private String node;

    /**
     * 用于签核历程的节点路径(PCM在用)
     */
    private String nodePath;

    // 设计态每个历程节点内容(新版)
    private List<Card.DesignerRawCard.Content> contentList;

    @Data
    static
    class TaskProgressContent {

        /**
         * 历程名称
         */
        private String title;

        /**
         * 历程状态标签
         */
        private List<Tag> tags;

        //运行态每个历程节点内容(新版)
        @JsonDeserialize(contentUsing = BaseMobileComponentWrapperJsonDeserializer.class)
        private List<BaseMobileComponentWrapper<BaseMobileComponent>> contentGroup = new ArrayList<>();
    }


    public static TaskProgress createApcProgress(int i, Map<String, Object> reportAbnormal,
                                                 String locale, LocaleService localeService,
                                                 String iamUserToken, DigiwinEocProxyService digiwinEocProxyService) {
        TaskProgress progress = new TaskProgress();
        progress.setId((String) reportAbnormal.get("abnormal_doc_no"));
        progress.setName((String) reportAbnormal.get("abnormal_reason_name"));
        if (i == 0) {
            progress.setState(TaskProgressStateEnum.DOING.getValue());
        } else {
            progress.setState(TaskProgressStateEnum.DONE.getValue());
        }
        List<TaskProgressPerson> personList = progress.getPersonList();
        TaskProgressPerson person = new TaskProgressPerson();
        person.setName((String) reportAbnormal.get("process_person_name"));
        String userId = "";
        if (reportAbnormal.get("process_person_no") != null) {
            EocPersonInfo personInfo = digiwinEocProxyService.getEocPersonInfo((String) reportAbnormal.get("process_person_no"), iamUserToken, 1);
            userId = personInfo.getUserId();
        }
        person.setUserId(userId);
        person.setComment((String) reportAbnormal.get("process_description"));
        person.setClosedTime((String) reportAbnormal.get("process_datetime"));
        int status = Integer.valueOf((String) reportAbnormal.get("process_status")).intValue();
        person.setState(status);
        if (ApcTaskProgressStateEnum.待处理.getValue() == status) {
            person.setReassignContent(localeService.getLanguageValue(locale,
                    ApcTaskProgressStateEnum.待处理.name()));
        } else if (ApcTaskProgressStateEnum.已处理.getValue() == status) {
            person.setReassignContent(localeService.getLanguageValue(locale,
                    ApcTaskProgressStateEnum.已处理.name()));
        } else if (ApcTaskProgressStateEnum.回复.getValue() == status) {
            person.setReassignContent(localeService.getLanguageValue(locale,
                    ApcTaskProgressStateEnum.回复.name()));
        } else if (ApcTaskProgressStateEnum.转派.getValue() == status) {
            person.setReassignContent(localeService.getLanguageValue(locale,
                    ApcTaskProgressStateEnum.转派.name()));
        } else if (ApcTaskProgressStateEnum.退回.getValue() == status) {
            person.setReassignContent(localeService.getLanguageValue(locale,
                    ApcTaskProgressStateEnum.退回.name()));
        } else if (ApcTaskProgressStateEnum.结案.getValue() == status) {
            person.setReassignContent(localeService.getLanguageValue(locale,
                    ApcTaskProgressStateEnum.结案.name()));
        }
        UiBotAttachment attachment = JsonUtil.objectToJavaObject(reportAbnormal.get("abnormal_handle_attachment"), UiBotAttachment.class);
        if (attachment != null && !CollectionUtils.isEmpty(attachment.getData())) {
            person.setFile(Attachment.uibotAttachmentparseAttachment(attachment, locale, "附件"));
        }
        personList.add(person);
        return progress;
    }

    public TaskProgress() {
    }

    public static TaskProgress create(String locale, DigiwinAtmcTaskProgress digiwinAtmcTaskProcess) {
        TaskProgress taskProgress = new TaskProgress();
        taskProgress.setId(digiwinAtmcTaskProcess.getBpmActivityId());
        taskProgress.setName(digiwinAtmcTaskProcess.getBpmActivityName());
        // wjw TODO: 2024/1/22 digiwinAtmcTaskProcess下state为null时，先默认为3，因为taskProgress的state为null时，前端组件展示异常
        if (null == digiwinAtmcTaskProcess.getState()) {
            digiwinAtmcTaskProcess.setState(3);
        }
        taskProgress.setState(TaskProgressStateEnum
                .getByPcStateNumber(digiwinAtmcTaskProcess.getState()).getValue());
        if (null != digiwinAtmcTaskProcess.getWorkitemList()) {
            taskProgress.setPersonList(
                    digiwinAtmcTaskProcess.getWorkitemList().stream()
                            .map(digiwinAtmcTaskProcessWorkItem -> {
                                TaskProgressPerson person = TaskProgressPerson.create(locale, digiwinAtmcTaskProcessWorkItem);
                                List<DigiwinAtmcTaskProgressWorkItemAttachment> attachments = digiwinAtmcTaskProcessWorkItem.getAttachments();
                                if (!CollectionUtils.isEmpty(attachments)) {
                                    person.setFile(Attachment.uibotAttachmentparseAttachment(attachments, locale, "附件"));
                                }
                                return person;
                            })
                            .collect(Collectors.toList())
            );
        } else {
            taskProgress.setPersonList(Collections.emptyList());
        }

        return taskProgress;
    }

    /**
     * 流程组件-历史流程进度
     *
     * @param locale
     * @param digiwinAtmcWorkflowSignHistory
     * @return
     */
    public static TaskProgress create(String locale, DigiwinAtmcWorkflowSignHistory digiwinAtmcWorkflowSignHistory) {
        TaskProgress taskProgress = new TaskProgress();
        taskProgress.setId(digiwinAtmcWorkflowSignHistory.getActivityId());
        taskProgress.setName(digiwinAtmcWorkflowSignHistory.getActivityName());
        // wjw TODO: 2024/1/22 digiwinAtmcTaskProcess下state为null时，先默认为3，因为taskProgress的state为null时，前端组件展示异常
        if (ObjectUtils.isEmpty(digiwinAtmcWorkflowSignHistory.getState())) {
            digiwinAtmcWorkflowSignHistory.setState(3);
        }
        taskProgress.setState(TaskProgressStateEnum
                .getByPcStateNumber(digiwinAtmcWorkflowSignHistory.getState()).getValue());
        if (CollectionUtils.isEmpty(digiwinAtmcWorkflowSignHistory.getWorkItems())) {
            taskProgress.setPersonList(Collections.emptyList());
        } else {
            List<TaskProgressPerson> progressPeople = new ArrayList<>();
            String activityType = digiwinAtmcWorkflowSignHistory.getActivityType();
            List<DigiwinAtmcWorkflowSignHistory.WorkItem> workItems = digiwinAtmcWorkflowSignHistory.getWorkItems();
            for (int i = 0; i < workItems.size(); i++) {
                List<DigiwinAtmcTaskProgressWorkItem> items = workItems.get(i).getItem();
                progressPeople.addAll(
                        items.stream()
                                .map(item -> {
                                    TaskProgressPerson person = TaskProgressPerson.create(item, activityType, locale);
                                    List<DigiwinAtmcTaskProgressWorkItemAttachment> attachments = item.getAttachments();
                                    if (!CollectionUtils.isEmpty(attachments)) {
                                        person.setFile(Attachment.uibotAttachmentparseAttachment(attachments, locale, "附件"));
                                    }
                                    return person;
                                })
                                .collect(Collectors.toList())
                );
            }
            taskProgress.setPersonList(progressPeople);
        }
        return taskProgress;
    }

    /**
     * 流程组件-未开始流程进度
     *
     * @param locale
     * @param digiwinAtmcWorkflowPreSign
     * @return
     */
    public static TaskProgress create(String locale, DigiwinAtmcWorkflowPreSign digiwinAtmcWorkflowPreSign) {
        TaskProgress taskProgress = new TaskProgress();
        taskProgress.setId("");
        taskProgress.setName(digiwinAtmcWorkflowPreSign.getActivityName());
        taskProgress.setState(TaskProgressStateEnum.getByPcStateNumber(0).getValue());
        if (CollectionUtils.isEmpty(digiwinAtmcWorkflowPreSign.getWorkItems())) {
            taskProgress.setPersonList(Collections.emptyList());
        } else {
            List<TaskProgressPerson> progressPeople = new ArrayList<>();
            List<DigiwinAtmcWorkflowPreSign.WorkItem> workItems = digiwinAtmcWorkflowPreSign.getWorkItems();
            for (int i = 0; i < workItems.size(); i++) {
                List<DigiwinAtmcWorkflowPreSign.Item> items = workItems.get(i).getItem();
                progressPeople.addAll(
                        items.stream()
                                .map(item -> {
                                    TaskProgressPerson person = TaskProgressPerson.create(item);
                                    return person;
                                })
                                .collect(Collectors.toList())
                );
            }
            taskProgress.setPersonList(progressPeople);
        }
        return taskProgress;
    }

    public static TaskProgress create(String locale, DigiwinBpmRedoTask digiwinBpmRedoTask) {
        TaskProgress taskProgress = new TaskProgress();
        taskProgress.setId(digiwinBpmRedoTask.getBpmActivityId());
        taskProgress.setName(digiwinBpmRedoTask.getBpmActivityName());

        List<TaskProgressPerson> personList = new ArrayList<>();
        personList.add(TaskProgressPerson.create(locale, digiwinBpmRedoTask));
        taskProgress.setPersonList(personList);
        taskProgress.setState(TaskProgressStateEnum.DONE.getValue());

        return taskProgress;
    }

    public static TaskProgress create(String locale, DigiwinReassignReport reassignReport, Integer state) {
        TaskProgress taskProgress = new TaskProgress();
        taskProgress.setStyleType(2);
        taskProgress.setId(String.valueOf(reassignReport.getId()));
        taskProgress.setName(reassignReport.getOldPerformerName() +
                LocaleUtil.getMobileTextByKey(locale, "转派至") + reassignReport.getNewPerformerName());
        List<TaskProgressPerson> personList = new ArrayList<>();
        personList.add(TaskProgressPerson.create(locale, reassignReport, state));
        taskProgress.setPersonList(personList);
        taskProgress.setState(state);
        return taskProgress;
    }

}
