package com.digiwin.mobile.mobileuibot.core.component.progress;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.EditCard;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.task.model.StateAttribute;
import com.digiwin.mobile.mobileuibot.task.model.TaskProgressPerson;
import com.digiwin.mobile.mobileuibot.task.model.TaskProgressStateEnum;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

import static com.digiwin.mobile.mobileuibot.core.component.card.card.Card.*;

/**
 * <p>功能描述：任务进度</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskProgress
 * @Author: Zaregoto
 * @Date: 2021/5/21 20:19
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TaskProgressList extends BaseMobileComponent {
    private static final long serialVersionUID = 2506512381261018371L;

    public static final String COMPONENT_TYPE = "TASK_PROGRESS_LIST";

    private static LocaleService localeService = SpringContextHolder.getBean(LocaleServiceImpl.class);

    @Override
    public String returnComponentType() {
        return TaskProgressList.COMPONENT_TYPE;
    }

    private List<TaskProgress> taskProgressList = new ArrayList<>();
    /**
     * 是否需要展开
     */
    private Boolean showMore = false;
    /**
     * 显示名称
     */
    private String title;

    /**
     * 是否是新结构，用于前端判断逻辑,默认false
     */
    private Boolean isNew = false;

    /**
     * 设计器配置：扩展内容
     */
    private ExtendConfig extendConfig;

    @Data
    static
    class ExtendConfig {
        /**
         * 默认false，true代表使用扩展
         */
        private Boolean isOpen;

        private List<ExtendModel> contentList;
    }

    @Data
    static
    class ExtendModel {
        private List<Integer> status;

        private DetailModel title;

        private List<DetailModel> content;

        @Data
        static
        class DetailModel {
            private String scheme;

            private String mobilePath;

            private String label;

            private Object setting;
        }
    }

    /**
     * 处理扩展字段参数
     *
     * @param status
     * @param progressPerson
     * @param map
     */
    private void HandleExtendConfig(Integer status, TaskProgressPerson progressPerson, Map<String, Object> map) {
        List<ExtendModel> collect = this.extendConfig.getContentList()
                .stream()
                .filter(model -> model.getStatus().contains(status)).collect(Collectors.toList());
        for (ExtendModel extendModel : collect) {
            if (CollectionUtils.isEmpty(extendModel.getStatus())) {
                continue;
            }
            if (CollectionUtils.isEmpty(extendModel.getContent())) {
                continue;
            }
            ExtendModel.DetailModel nameModel = extendModel.getTitle();
            if (ObjectUtils.isEmpty(map.get(nameModel.getScheme()))) {
                progressPerson.setName(nameModel.getLabel() + " —");
            } else {
                progressPerson.setName(nameModel.getLabel() + map.get(nameModel.getScheme()));
            }

            List<ExtendModel.DetailModel> contentList = extendModel.getContent();
            //前端对ClosedTime做转换，所以加ClosedTimeLabel，交给前端判断拼接
            String value = contentList.get(0).getLabel();
            if (ObjectUtils.isEmpty(map.get(contentList.get(0).getScheme()))) {
                value = value + " —";
            } else {
                value = value + map.get(contentList.get(0).getScheme());
            }
            if (contentList.size() != 1) {
                if (ObjectUtils.isEmpty(map.get(contentList.get(1).getScheme()))) {
                    progressPerson.setComment(contentList.get(1).getLabel() + " —" + "\n" + value);
                } else {
                    progressPerson.setComment(contentList.get(1).getLabel() + map.get(contentList.get(1).getScheme()) + "\n" + value);
                }
            }
        }
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        if (CollectionUtils.isEmpty(taskProgressList)) {
            return;
        }
        TaskProgress taskProgress = taskProgressList.get(0);
        // wjw TODO: 2024/9/10 此方法内部会直接return（因actionName=mainDataSourceName），故需去除之前的多数据源处理逻辑（UiBotModelDesignerMultipleDataSources，注意需迁移之前的任务卡多数据源配置）
        super.resetCmptMultipleDataSourceData(cmptContext, executeContext, taskProgress.getDataSource(), data);
        Object value = UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
        if (ObjectUtils.isEmpty(value)) {
            return;
        }
        List<Map<String, Object>> rawMap = JsonUtil.objectToJavaObject(value, new TypeReference<List<Map<String, Object>>>() {
        });
        List<TaskProgress> list = new ArrayList<>();
        //根据contentList的个数来判断是否为空走新老逻辑，不为0走新逻辑，为0或null走旧逻辑
        if (!CollectionUtils.isEmpty(taskProgress.getContentList())) {
            this.isNew = true;
            //构建每个历程节点下的数据
            list = buildTaskProgressList(rawMap, taskProgress, cmptContext, executeContext, mobilePageRawData);
            taskProgress.setContentList(null);
        } else {
            if (CollectionUtils.isEmpty(taskProgress.getPersonList())) {
                return;
            }
            TaskProgressPerson person = taskProgress.getPersonList().get(0);
            for (Map<String, Object> map : rawMap) {
                TaskProgress task = new TaskProgress();
                List<TaskProgressPerson> personList = task.getPersonList();
                if (ObjectUtils.isEmpty(map.get("state"))) {
                    task.setState(TaskProgressStateEnum
                            .getByPcStateNumber(TaskProgressStateEnum.TODO.getValue()).getValue());
                } else {
                    task.setState(TaskProgressStateEnum
                            .getByPcStateNumber((Integer) map.get("state")).getValue());
                }
                if (ObjectUtils.isNotEmpty(map.get(taskProgress.getName()))) {
                    task.setName(Card.getDisplayValue(taskProgress.getNameSetting(), StringUtil.valueOf(map.get(taskProgress.getName()))));
                }
                if (ObjectUtils.isNotEmpty(person.getNode())) {
                    //改造逻辑,当节点下又有一个list节点的时候走以下方法
                    personList.add(isNodeExist(map, taskProgress, person, cmptContext));
                } else {
                    //原逻辑
                    personList.add(notNodeExist(map, taskProgress, person, cmptContext));
                }

                task.setPersonList(personList);
                list.add(task);
            }
        }
        this.taskProgressList = list;
    }

    public TaskProgressPerson notNodeExist(Map<String, Object> map, TaskProgress taskProgress, TaskProgressPerson person, ComponentContext cmptContext) {
        TaskProgressPerson notNodeExistPerson = new TaskProgressPerson();
        if (ObjectUtils.isNotEmpty(extendConfig) &&
                (BooleanUtils.isTrue(extendConfig.isOpen) && !CollectionUtils.isEmpty(extendConfig.getContentList()))) {
            this.HandleExtendConfig(Integer.parseInt(StringUtil.valueOf(map.get(taskProgress.getStatus()))), notNodeExistPerson, map);
        } else {
            notNodeExistPerson.setName(StringUtil.valueOf(map.get(person.getName())));
            if (ObjectUtils.isNotEmpty(map.get(person.getClosedTime()))) {
                String closedTime = StringUtil.valueOf(map.get(person.getClosedTime()));
                if (closedTime.contains("1900") || closedTime.contains("9998")) {
                    notNodeExistPerson.setClosedTime(null);
                } else {
                    notNodeExistPerson.setClosedTime(closedTime);
                }

            }
            if (ObjectUtils.isNotEmpty(map.get(person.getComment()))) {
                if (StringUtils.isNotBlank(person.getCommentDesc())) {
                    notNodeExistPerson.setCommetPrefix(localeService.getLanguageValue(cmptContext.getLocale(), person.getCommentDesc()) + ":");
                }
                notNodeExistPerson.setComment(StringUtil.valueOf(map.get(person.getComment())));
            }

            // wjw TODO: 2025/2/25 普通的处理历程组件。走普通的处理历程渲染逻辑，不应调用签核的渲染逻辑
//            //签核历程组件，先默认后端写死
//            notNodeExistPerson.setCreateType((Integer) map.get("createType"));
//            notNodeExistPerson.setState((Integer) map.get("state"));
//            notNodeExistPerson.setState((Integer) map.get("subState"));
//
//            notNodeExistPerson = TaskProgressPerson.handleStateStyle(cmptContext.getLocale(), notNodeExistPerson);

            List<StateAttribute> stateAttributes = TaskProgressPerson.buildStateAttribute(person.getStateAttrSetting(), map);
            if (!CollectionUtils.isEmpty(stateAttributes)) {
                // 设计器配置的情况下才设置，否则走签核历程的默认逻辑
                notNodeExistPerson.setStateAttribute(stateAttributes);
            }
            notNodeExistPerson.setFile(TaskProgressPerson.buildFile(person.getAttachmentSetting(), map));
        }
        return notNodeExistPerson;
    }

    public TaskProgressPerson isNodeExist(Map<String, Object> map, TaskProgress taskProgress, TaskProgressPerson person, ComponentContext cmptContext) {
        TaskProgressPerson isNodeExistPerson = new TaskProgressPerson();
        if (ObjectUtils.isNotEmpty(extendConfig) &&
                (BooleanUtils.isTrue(extendConfig.isOpen) && !CollectionUtils.isEmpty(extendConfig.getContentList()))) {
            this.HandleExtendConfig(Integer.parseInt(StringUtil.valueOf(map.get(taskProgress.getStatus()))), isNodeExistPerson, map);
        } else {
            List<LinkedHashMap> chirdNodes = new ArrayList<LinkedHashMap>();
            chirdNodes = (List) map.get(person.getNode());
            for (LinkedHashMap chirdNode : chirdNodes) {
                isNodeExistPerson.setName(StringUtil.valueOf(chirdNode.get(person.getName())));
                if (ObjectUtils.isNotEmpty(chirdNode.get(person.getClosedTime()))) {
                    String closedTime = StringUtil.valueOf(chirdNode.get(person.getClosedTime()));
                    if (closedTime.contains("1900") || closedTime.contains("9998")) {
                        isNodeExistPerson.setClosedTime(null);
                    } else {
                        isNodeExistPerson.setClosedTime(closedTime);
                    }
                }
                if (ObjectUtils.isNotEmpty(chirdNode.get(person.getComment()))) {
                    isNodeExistPerson.setComment(StringUtil.valueOf(chirdNode.get(person.getComment())));
                }
                //签核历程组件，先默认后端写死
                isNodeExistPerson.setCreateType((Integer) chirdNode.get("createType"));
                isNodeExistPerson.setState((Integer) chirdNode.get("state"));
                isNodeExistPerson.setSubState((Integer) chirdNode.get("subState"));
                isNodeExistPerson = TaskProgressPerson.handleStateStyle(cmptContext.getLocale(), isNodeExistPerson);
                List<StateAttribute> stateAttributes = TaskProgressPerson.buildStateAttribute(person.getStateAttrSetting(), map);
                if (!CollectionUtils.isEmpty(stateAttributes)) {
                    // 设计器配置的情况下才设置，否则走签核历程的默认逻辑
                    isNodeExistPerson.setStateAttribute(stateAttributes);
                }
                isNodeExistPerson.setFile(TaskProgressPerson.buildFile(person.getAttachmentSetting(), map));
            }
        }
        return isNodeExistPerson;
    }


    private Integer getStatus(Integer status, String locale) {
        TaskProgress taskProgress = taskProgressList.get(0);
        String displayValue = Card.getDisplayValue(taskProgress.getStatusSetting(), StringUtil.valueOf(status));
        if (StringUtils.isNotBlank(displayValue)) {
            if (displayValue.equalsIgnoreCase(localeService.getLanguageValue(locale, "待处理"))) {
                return TaskProgressStateEnum.DONE.getValue();
            }
            if (displayValue.equalsIgnoreCase(localeService.getLanguageValue(locale, "已完成"))) {
                return TaskProgressStateEnum.DOING.getValue();
            }
            return Integer.valueOf(displayValue);
        }
        return null;
    }

    /**
     * 构建每个历程节点下的数据
     *
     * @param rawMap
     * @param taskProgress
     * @param cmptContext
     * @return
     */
    private List<TaskProgress> buildTaskProgressList(List<Map<String, Object>> rawMap, TaskProgress taskProgress, ComponentContext cmptContext,
                                                     PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        List<TaskProgress> list = new ArrayList<>();
        for (Map<String, Object> rawData : rawMap) {
            TaskProgress task = new TaskProgress();
            //构建历程名称
            if (ObjectUtils.isNotEmpty(rawData.get(taskProgress.getName()))) {
                task.setName(Card.getDisplayValue(taskProgress.getNameSetting(), StringUtil.valueOf(rawData.get(taskProgress.getName()))));
            }
            //构建历程的图标
            if (ObjectUtils.isEmpty(rawData.get("state"))) {
                task.setState(TaskProgressStateEnum
                        .getByPcStateNumber(TaskProgressStateEnum.TODO.getValue()).getValue());
            } else {
                task.setState(TaskProgressStateEnum
                        .getByPcStateNumber((Integer) rawData.get("state")).getValue());
            }
            List<TaskProgress.TaskProgressContent> taskProgressContentList = new ArrayList<>();
            //构建每个历程下的数据
            if (!ObjectUtils.isEmpty(taskProgress.getNode())) {
                //有节点是签核流程
                List<LinkedHashMap<String, Object>> chirdRawData = (List) rawData.get(task.getNode());
                for (LinkedHashMap<String, Object> data : chirdRawData) {
                    TaskProgress.TaskProgressContent taskProgressContent = buildTaskProgressContent(data, taskProgress, true, cmptContext, executeContext, mobilePageRawData);
                    taskProgressContentList.add(taskProgressContent);
                }
            } else {
                //无节点是标准处理历程
                taskProgressContentList.add(buildTaskProgressContent(rawData, taskProgress, false, cmptContext, executeContext, mobilePageRawData));
            }
            task.setData(taskProgressContentList);
            list.add(task);
        }
        return list;
    }

    /**
     * 构建每个处理历程下的节点内容(新)
     *
     * @param rawData
     * @param taskProgress
     * @param existNode
     * @param cmptContext
     * @return
     */
    private TaskProgress.TaskProgressContent buildTaskProgressContent(Map<String, Object> rawData, TaskProgress taskProgress, Boolean existNode, ComponentContext cmptContext, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        // 构建TAG
        TaskProgress.TaskProgressContent taskProgressContent = new TaskProgress.TaskProgressContent();
        taskProgressContent.setTags(Card.buildTags(taskProgress.getContentList(), rawData, null));
        //签核历程需要额外处理tag标签
        if (existNode && CollectionUtils.isEmpty(taskProgressContent.getTags())) {
            //签核历程下的tag如果不配置则需要手动算出来
            TaskProgressPerson person = new TaskProgressPerson();
            person.setCreateType((Integer) rawData.get("createType"));
            person.setState((Integer) rawData.get("state"));
            person.setSubState((Integer) rawData.get("subState"));
            person.setIsReassign(BooleanUtils.isTrue(
                    Optional.ofNullable(rawData.get("isReassign"))
                            .filter(Boolean.class::isInstance)
                            .map(Boolean.class::cast)
                            .orElse(null)
            ));
            person = TaskProgressPerson.handleStateStyle(cmptContext.getLocale(), person);
            //将原本的StateAttribute转换为tag结构
            taskProgressContent.setTags(covertStateToTags(person));
        }
        //  过滤 非TAG 类型的数据
        List<DesignerRawCard.Content> nonTagContentList = taskProgress.getContentList().stream()
                .filter(a -> !"TAG".equalsIgnoreCase(a.getType()))
                .collect(Collectors.toList());
        //将第一笔数据提出来设置title
        Card.DesignerRawCard.Content titleContent = nonTagContentList.stream()
                .findFirst()
                .orElse(null);
        if (titleContent != null) {
            taskProgressContent.setTitle(getLableValue(titleContent.getSetting(), StringUtil.valueOf(rawData.get(titleContent.getSchema()))));
        }
        // 获取剩下的组件数据构建历程中的数据
        List<Card.DesignerRawCard.Content> remainingContent = nonTagContentList.stream()
                .skip(1) // 跳过第一个元素
                .collect(Collectors.toList());
        //构建历程中的每个组件
        DesignerRawCard designerRawCard = new DesignerRawCard();
        designerRawCard.setContent(remainingContent);
        taskProgressContent.setContentGroup(EditCard.buildContentGroup(designerRawCard, cmptContext, rawData, executeContext, mobilePageRawData));
        return taskProgressContent;
    }

    /**
     * 旧的处理历程状态和新的处理历程状态转换
     *
     * @param person
     * @return
     */
    private List<Tag> covertStateToTags(TaskProgressPerson person) {
        List<Tag> tags = new ArrayList<>();
        if (CollectionUtils.isEmpty(person.getStateAttribute())) {
            return tags;
        }
        for (StateAttribute stateAttribute : person.getStateAttribute()) {
            Tag tag = new Tag();
            tag.setText(stateAttribute.getContent());
            tag.setType(0);
            tag.setBgColor(stateAttribute.getBorderColor());
            tag.setBorderColor(stateAttribute.getBorderColor());
            tag.setTextColor(stateAttribute.getColor());
            tags.add(tag);
        }
        return tags;
    }
}
