package com.digiwin.mobile.mobileuibot.core.component.progressbar;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;

/**
 * <p>功能描述：设计器--进度条组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ProgressBar.java
 * @Author: guja
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ProgressBar extends BaseInputMobileComponent implements Serializable {

    private static final long serialVersionUID = 1174984245387959107L;

    public static final String COMPONENT_TYPE = "PROGRESS_BAR";

    @Override
    public String returnComponentType() {
        return ProgressBar.COMPONENT_TYPE;
    }

    /**
     * 进度条名字
     */
    private String title;

    /**
     * 进度条最小值
     */
    private BigDecimal minValue = BigDecimal.ZERO;

    /**
     * 进度条最大值
     */
    private BigDecimal maxValue = new BigDecimal("100");

    /**
     * 进度条默认值
     */
    private BigDecimal defaultValue;

    /**
     * 1为整数，2为小数(默认为1)
     */
    private Integer type = ProgressBarTypeEnum.INTEGER_TYPE.getValue();

    /**
     * 小数位数，默认为2，当type==2时字段生效
     */
    private Integer decimals = ProgressBarDecimalsEnum.DECIMALS_TWO.getValue();

    /**
     * 单位 默认%
     */
    private String unit = "%";

    /**
     * 渐变色
     * 红色：F03C81→F0021D
     * 橙色：FFC084→FF8160
     * 蓝色：91BAFF→5465FF
     */
    private String activeColor1;
    private String activeColor2;


    private BigDecimal returnDefaultValue(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(value.toString());
        } catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        BigDecimal value = this.returnDefaultValue(UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema));
        if (ProgressBarTypeEnum.INTEGER_TYPE.getValue().equals(this.type)) {
            // 配置整数类型，但是给的是小数，需要四舍五入
            this.defaultValue = value.setScale(0, RoundingMode.HALF_UP);
            this.maxValue = maxValue.setScale(0, RoundingMode.HALF_UP);
            this.minValue = minValue.setScale(0, RoundingMode.HALF_UP);
        } else {
            // 小数情况下，位数变更
            this.defaultValue = value.setScale(decimals, RoundingMode.HALF_UP);
            this.maxValue = maxValue.setScale(decimals, RoundingMode.HALF_UP);
            this.minValue = minValue.setScale(decimals, RoundingMode.HALF_UP);
        }
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        ProgressBar progressBar = new ProgressBar();
        progressBar.setComponentId(rawContent.getComponentId());
        progressBar.setTitle(rawContent.getLabel());
        progressBar.setEnable(rawContent.getEditable());
        //将配置中的setting转化成成对象
        Card.DesignerRawCard.Content.ProgressBarObj progressBarObj = JsonUtil.objectToJavaObject(rawContent.getSetting(), Card.DesignerRawCard.Content.ProgressBarObj.class);
        if (progressBarObj != null) {
            progressBar.setMinValue(progressBarObj.getMinValue());
            progressBar.setMaxValue(progressBarObj.getMaxValue());
            progressBar.setType(progressBarObj.getType());
            progressBar.setDecimals(progressBarObj.getDecimals());
            progressBar.setUnit(progressBarObj.getUnit());
            progressBar.setActiveColor1(progressBarObj.getActiveColor1());
            progressBar.setActiveColor2(progressBarObj.getActiveColor2());
        }
        progressBar.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return progressBar;

    }
}
