package com.digiwin.mobile.mobileuibot.core.component.progressbar;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * <p>功能描述：进度条组件提交参数分析器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ProgressBarParamAnalyzer.java
 * @Author: wangjwc
 * @Date: created at 2024/8/7 11:33
 */
@Component
@Slf4j
public class ProgressBarParamAnalyzer implements ComponentParamAnalyzer<ProgressBar, Number> {
    @Override
    public String getComponentType() {
        return ProgressBar.COMPONENT_TYPE;
    }

    @Override
    public Class<ProgressBar> getSubmitParamType() {
        return ProgressBar.class;
    }

    @Override
    public Number analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof ProgressBar)) {
            log.debug("submitParam is not instanceof ProgressBar component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return null;
        }
        return ((ProgressBar) submitParam).getDefaultValue();
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object... args) {
    }
}