package com.digiwin.mobile.mobileuibot.core.component.qrcode;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.Set;

/**
 * 二维码组件
 *
 * @author zhangjj
 * @date 2022/9/14 15:48
 */
@Data
public class QrCode extends BaseMobileComponent implements Serializable {
    private static final long serialVersionUID = 1174984745387959107L;
    public static final String COMPONENT_TYPE = "QR_CODE";

    /**
     * 二维码内容
     */
    private String content;

    /**
     * 提示文字，显示在二维码下面
     */
    private String hint;


    public static QrCode create(QrCodeContentMsg qrCodeContentMsg, String hint) {
        QrCode qrCode = new QrCode();
        //todo 先用服务地址，后期换成跳转/下载app的h5页面
        String content = AppContext.getBaseUrl();
        StringBuffer sb = new StringBuffer();
        if (StringUtils.hasLength(qrCodeContentMsg.getBizType())) {
            sb.append("&bizType=").append(qrCodeContentMsg.getBizType());
        }
        if (StringUtils.hasLength(qrCodeContentMsg.getTimestamp())) {
            sb.append("&timestamp=").append(qrCodeContentMsg.getTimestamp());
        }
        Set<String> keys = qrCodeContentMsg.keySet();
        keys.forEach(key -> {
            String value = qrCodeContentMsg.get(key);
            if (StringUtils.hasLength(key) && StringUtils.hasLength(value)) {
                sb.append("&").append(key).append("=").append(value);
            }
        });
        if (sb.length() > 0) {
            String suffix = sb.substring(1);
            content += "?" + suffix;
        }
        qrCode.setContent(content);
        qrCode.setHint(hint);
        return qrCode;
    }

    @Override
    public String returnComponentType() {
        return QrCode.COMPONENT_TYPE;
    }
}
